package com.digiwin.athena.base.application.service.importstatistics.service.impl;

import com.digiwin.athena.atdm.importstatistics.entity.CellTypeContainer;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelTypeEnum;
import com.digiwin.athena.base.application.service.importstatistics.service.helpler.ExcelHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @ClassName ImportStatisticsService
 * @Description 导入数据领域服务
 * @Author zhuangli
 * @Date 2021/4/6 17:51
 * @Version 1.0
 **/
@Slf4j
@Service
public class DataEntryImportStatisticsDomainService {

    @Autowired
    ExcelHelper excelHelper;

    public final String SHEET_NAME = "sheet1";
    private final String EXCEL_SUFFIX = ".xlsx";

    public void handleDownloadBaseData(String locale, String name, List<String> keyList, Map<String, String> headers, Map<String, CellTypeContainer> cellTypeContainerMap,
                                       List<Map<String, Object>> tableList, HttpServletResponse response, String sheetName) throws UnsupportedEncodingException {
        Workbook wb = new XSSFWorkbook();
        int rowIndex = 2;
        List<CellTypeContainer> businessKeyContainer = excelHelper.getBusinessKeyContainer(new ArrayList<>(cellTypeContainerMap.values()));
        excelHelper.createDataExcel(sheetName, locale, rowIndex, keyList, cellTypeContainerMap, headers, tableList, wb,businessKeyContainer,0,null,null);
        response.setContentType(ExcelTypeEnum.XLSX.value());
        String encoding = "UTF-8";
        String formFileName = name + EXCEL_SUFFIX;

        formFileName = URLEncoder.encode(formFileName, "UTF-8");
        response.setCharacterEncoding(encoding);
        // 解决URLEncoder.encode方法会把空格变成加号（+）在前台页面显示的时候会多出加号的问题
        formFileName = formFileName.replaceAll("\\+",  "%20");
        response.addHeader("Content-Disposition", "attachment;filename=" + formFileName);
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        try {
            OutputStream os = response.getOutputStream();
            wb.write(os);
        } catch (Exception e) {
            log.error("导出异常数据写入文件异常", e);
        } finally {
            if (null != wb) {
                try {
                    wb.close();
                } catch (IOException e) {
                    log.error(e.toString());
                }
            }
        }
    }
}
