package com.digiwin.athena.base.application.service.tenantauth;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.base.infrastructure.constant.Constants;
import com.digiwin.athena.base.infrastructure.constant.TenantEnum;
import com.digiwin.athena.base.infrastructure.manager.iam.service.BaseIamService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 外部客户邮件注册开通个人租户并授权雅典娜
 * @createDate: 2023/3/16 15:20
 * @author: sunyfa
 */
@Service
@Slf4j
public class TenantAuthServiceImpl implements ITenantAuthService {
    @Autowired
    private BaseIamService baseIamService;

    @Override
    public Map<String, String> getTargetTenantAndUser (AuthoredUser authoredUser, String email, String phone) {
        log.info("External customer email registration opens personal tenant and authorizes Athena begin, email:{}, " +
                "phone:{}", email, phone);

        // 获取已存在个人租户和用户
        Map<String, Object> tenantAuthMap = baseIamService.getTenantAuth(authoredUser, email, phone, Constants.ATHENA_APPID,
                TenantEnum.INDIVIDUAL.getType());

        Map<String, String> resultMap = new HashMap<>();

        // 结果
        Integer status = MapUtils.getInteger(tenantAuthMap, "status");

        //处理返回值
        if (status == -1) { // 调用接口失败
            return null;
        }
        else if (status == 0) {// 没有个人租户，需要去创建个人租户并且授权
            Map<String, String> registerMap = baseIamService.registerTenant(authoredUser, email, phone,
                    Constants.ATHENA_APPID, "", "athena_light_01");

            if (MapUtils.isNotEmpty(registerMap)) {
                resultMap.put("individualTenantId", registerMap.get("id"));
                resultMap.put("userId", registerMap.get("userId"));
            }
        }
        else if (status == 1) {// 存在个人租户但没有授权
            //租户下是否有应用授权
            Boolean isTenantAuth = Boolean.valueOf(tenantAuthMap.get("isTenantAuth").toString());
            Boolean authorizeUserResult = baseIamService.authorizeUser(authoredUser,
                    tenantAuthMap.get("tenantId").toString(), email, phone, Constants.ATHENA_APPID, "",
                    "athena_light_01", isTenantAuth);

            if (authorizeUserResult) {
                resultMap.put("individualTenantId", tenantAuthMap.get("tenantId").toString());
                resultMap.put("userId", tenantAuthMap.get("userId").toString());
            }
        }
        else if (status == 2) {// 存在个人租户并且已授权
            resultMap.put("individualTenantId", tenantAuthMap.get("tenantId").toString());
            resultMap.put("userId", tenantAuthMap.get("userId").toString());
        }

        log.info("External customer email registration opens personal tenant and authorizes Athena end, result:{}",
                JsonUtils.objectToString(resultMap));

        return resultMap;
    }
}
