package com.digiwin.athena.base.application.service.usermeta;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.request.usermeta.UserMetadataItemReqDTO;
import com.digiwin.athena.base.application.meta.response.usermeta.UserMetadataItemRespDTO;

import java.util.List;

/**
 * UserMetadataService Description
 *
 * @author majianfu
 * @date 2024/8/22
 * @since
 */
public interface UserMetadataService {
    /**
     * 查询批量用户的消息发送方式设定。
     * 若入参userIds/tenantSid为空，则默认查询当前用户userId/tenantSid的消息发送方式设定
     * <p>
     * 若从IAM未能查询到该用户的元数据（用户不存在或初始化后未在Athena手动修改过元数据）或元数据中不包含消息发送方式，
     * 则默认返回该用户的消息发送方式为{@link com.digiwin.athena.audc.usermetadata.constant.MetadataConstant#MESSAGE_SEND_TYPE_IM}
     *
     * @param metadataItemReqDTO
     * @param authoredUser
     * @return
     */
    List<UserMetadataItemRespDTO> queryBatchUserMessageSendType(UserMetadataItemReqDTO metadataItemReqDTO, AuthoredUser authoredUser);
}
