package com.digiwin.athena.base.application.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/10/11 16:38:33
 */
public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    /**
     * StreamToString
     *
     * @param is 输入流
     * @return 字符串
     */
    public static String StreamToString(InputStream is) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, length);
            }
            outStream.close();
            is.close();
            return outStream.toString();
        } catch (IOException e) {
            logger.error("parse Stream error", e);
        }
        return "";
    }


    /**
     * 校验json格式是否符合要求
     * @param dataString  dataString
     * @param schemaString schemaString
     * @return String
     */
    public static ProcessingReport validate(String dataString, String schemaString) {
        ProcessingReport processingReport = null;
        try {
            JsonNode dataNode = JsonLoader.fromString(dataString);
            JsonNode schemaNode = JsonLoader.fromString(schemaString);
            JsonSchema schema = JsonSchemaFactory.byDefault().getJsonSchema(schemaNode);
            processingReport = schema.validate(dataNode);
            return processingReport;
        } catch (IOException | ProcessingException ex) {
            logger.error("check json file error", ex);
        }
        return processingReport;
    }
}
