/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.config;

import com.digiwin.athena.framework.core.config.env.DwOPSEnvPropertyHandler;
import com.jugg.agile.biz.digiwin.config.common.DwPrivateDeploymentProcessor;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.middleware.mongodb.spring.JaMongoTemplateProcessor;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

@Configuration
public class BaseMongeTemplateConfig {
    @Value(value="${spring.data.mongodb-track.uri}")
    private String uriTrack;
    @Value(value="${spring.data.mongodb-track.database}")
    private String databaseTrack;
    @Value(value="${spring.data.mongodb.database}")
    private String databaseLog;

    @Bean(value={"trackMongoTemplate"})
    public MongoTemplate trackMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriTrack)).build(), null);
        MongoTemplate msgMongoTemplate = new MongoTemplate((MongoClient)client, this.databaseTrack);
        MongoConverter converter = msgMongoTemplate.getConverter();
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter)converter).setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        }
        return msgMongoTemplate;
    }

    @ConditionalOnMissingBean(name={"mongoTemplate"})
    @Bean(value={"mongoTemplate"})
    public MongoTemplate mongoTemplate() {
        String uri = JaProperty.get((String)"spring.data.mongodb.uri");
        if (DwOPSEnvPropertyHandler.getIsLocal()) {
            uri = DwPrivateDeploymentProcessor.getMongoUri();
        }
        JaLog.info((String)"mongoTemplate : {}, {}", (Object[])new Object[]{uri, DwOPSEnvPropertyHandler.getIsLocal()});
        return JaMongoTemplateProcessor.createSimple((String)this.databaseLog, (String)uri);
    }
}

