/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.guide;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.request.guide.UserGuidePoJo;
import com.digiwin.athena.base.application.meta.response.guide.UserGuideResult;
import com.digiwin.athena.base.application.service.guide.UserGuideService;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import com.digiwin.athena.base.infrastructure.mapper.audc.guide.UserGuideInfoMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.guide.UserGuideLogMapper;
import com.digiwin.athena.base.infrastructure.meta.po.guide.UserGuideInfo;
import com.digiwin.athena.base.infrastructure.meta.po.guide.UserGuideLog;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class UserGuideServiceImpl
implements UserGuideService {
    private static final Logger logger = LoggerFactory.getLogger(UserGuideServiceImpl.class);
    private static final int GUIDE_STATE_DISABLE = 1;
    private static final int GUIDE_STATE_ENABLE = 0;
    private static final String DISABLE_SOURCE_MANUAL = "manual";
    private static final String DISABLE_SOURCE_AUTO = "auto";
    private final UserGuideInfoMapper userGuideInfoMapper;
    private final UserGuideLogMapper userGuideLogMapper;
    private final EnvProperties envProperties;
    private final RestTemplate restTemplate;

    @Autowired
    public UserGuideServiceImpl(UserGuideInfoMapper userGuideInfoMapper, UserGuideLogMapper userGuideLogMapper, EnvProperties envProperties, RestTemplate restTemplate) {
        this.userGuideInfoMapper = userGuideInfoMapper;
        this.userGuideLogMapper = userGuideLogMapper;
        this.envProperties = envProperties;
        this.restTemplate = restTemplate;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public UserGuideResult queryGuideInfo(UserGuidePoJo pojo) {
        UserGuideResult result = new UserGuideResult();
        UserGuideInfo guideInfo = this.queryGuideState(pojo);
        if (null == guideInfo) {
            try {
                guideInfo = this.addGuideInfo(pojo);
            }
            catch (Exception e) {
                logger.error("add new guide info error,params:{}", (Object)JsonUtils.objectToString((Object)pojo), (Object)e);
                throw BusinessException.create((Integer)1003, (String)"Add new guide info error.");
            }
        }
        if (1 == guideInfo.getState()) {
            throw BusinessException.create((Integer)1001, (String)"State is disable.");
        }
        Map<String, Object> guideDefine = this.queryGuideNoteInfo(pojo);
        Map guideDetail = (Map)guideDefine.get(pojo.getSubKey());
        if (null == guideDetail) {
            throw BusinessException.create((Integer)1009, (String)"Guide Define not contain SubKey");
        }
        String content = MapUtils.getString((Map)guideDetail, (Object)"content");
        int maxNum = MapUtils.getIntValue((Map)guideDetail, (Object)"maxCount");
        if (StringUtils.isEmpty((String)content)) {
            throw BusinessException.create((Integer)1010, (String)"Guide Define not contain Content");
        }
        Long visitCount = this.queryCount(pojo);
        if (visitCount >= (long)maxNum) {
            pojo.setState(1);
            try {
                this.updateUserGuideState(pojo, DISABLE_SOURCE_AUTO);
            }
            catch (Exception e) {
                logger.error("update user guide info state error{} ", (Object)JsonUtils.objectToString((Object)pojo), (Object)e);
                throw BusinessException.create((Integer)1004, (String)"update guide info state error.");
            }
            throw BusinessException.create((Integer)1002, (String)"Above Max visit number.");
        }
        this.recordUserGuildLog(pojo);
        result.setData(content);
        return result;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public UserGuideResult disableGuideInfo(UserGuidePoJo pojo) {
        UserGuideResult result = new UserGuideResult();
        try {
            this.updateUserGuideState(pojo, DISABLE_SOURCE_MANUAL);
        }
        catch (Exception e) {
            logger.error("disableGuideInfo error", (Throwable)e);
            throw BusinessException.create((Integer)1012, (String)"update guide info state error.");
        }
        return result;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public UserGuideResult resetUserGuideInfo(String userId) {
        UserGuideResult result = new UserGuideResult();
        try {
            QueryWrapper logQueryWrapper = new QueryWrapper();
            logQueryWrapper.eq((Object)"user_id", (Object)userId);
            this.userGuideLogMapper.delete((Wrapper)logQueryWrapper);
            QueryWrapper infoQueryWrapper = new QueryWrapper();
            infoQueryWrapper.eq((Object)"user_id", (Object)userId);
            this.userGuideInfoMapper.delete((Wrapper)infoQueryWrapper);
        }
        catch (Exception e) {
            logger.error("resetUserGuideInfo error", (Throwable)e);
            throw BusinessException.create((Integer)1013, (String)"reset user info state error.");
        }
        return result;
    }

    private UserGuideInfo addGuideInfo(UserGuidePoJo param) {
        UserGuideInfo userGuideInfo = new UserGuideInfo();
        userGuideInfo.setUserId(param.getUserId());
        userGuideInfo.setTenantId(param.getTenantId());
        userGuideInfo.setAppCode(param.getAppCode());
        userGuideInfo.setModularCode(param.getModularCode());
        userGuideInfo.setState(Integer.valueOf(0));
        userGuideInfo.setCreateDate(LocalDateTime.now());
        userGuideInfo.setTerminalType("web");
        userGuideInfo.setSubKey(param.getSubKey());
        userGuideInfo.setCode(param.getCode());
        this.userGuideInfoMapper.insert((Object)userGuideInfo);
        return userGuideInfo;
    }

    private Map<String, Object> queryGuideNoteInfo(UserGuidePoJo param) {
        ResponseEntity responseEntity;
        String url = this.envProperties.getThemeMapUri() + "/restful/service/knowledgegraph/Guide/query";
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        headerMap.add("locale", LocaleContextHolder.getLocale().toString());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appCode", param.getAppCode());
        map.put("code", param.getCode());
        map.put("type", param.getModularCode());
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headerMap);
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<JSONObject>>(){}, new Object[0]);
        }
        catch (Exception e) {
            logger.error("query guide info from km error");
            throw BusinessException.create((Integer)1011, (String)"Request KM error,But no data return");
        }
        if (responseEntity.getStatusCodeValue() == HttpStatus.OK.value() && responseEntity.getBody() != null) {
            JSONObject object = (JSONObject)((BaseResultDTO)responseEntity.getBody()).getResponse();
            if (null == object) {
                throw BusinessException.create((Integer)1008, (String)"Request KM Success,But no data return");
            }
            return this.parseResult(object);
        }
        throw BusinessException.create((Integer)1007, (String)"Request KM Fail");
    }

    private Map<String, Object> parseResult(JSONObject jsonObject) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        JSONArray guideArrs = jsonObject.getJSONArray("settings");
        if (null != guideArrs) {
            for (int i = 0; i < guideArrs.size(); ++i) {
                JSONObject temp = guideArrs.getJSONObject(i);
                retMap.put(temp.getString("key"), temp);
            }
        }
        return retMap;
    }

    private UserGuideInfo queryGuideState(UserGuidePoJo param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)param.getUserId());
        queryWrapper.eq((Object)"tenant_id", (Object)param.getTenantId());
        queryWrapper.eq((Object)"modular_code", (Object)param.getModularCode());
        queryWrapper.eq((Object)"code", (Object)param.getCode());
        queryWrapper.eq((Object)"sub_key", (Object)param.getSubKey());
        return (UserGuideInfo)this.userGuideInfoMapper.selectOne((Wrapper)queryWrapper);
    }

    private Long queryCount(UserGuidePoJo pojo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)pojo.getUserId());
        queryWrapper.eq((Object)"tenant_id", (Object)pojo.getTenantId());
        queryWrapper.eq((Object)"modular_code", (Object)pojo.getModularCode());
        queryWrapper.eq((Object)"code", (Object)pojo.getCode());
        queryWrapper.eq((Object)"sub_key", (Object)pojo.getSubKey());
        return this.userGuideLogMapper.selectCount((Wrapper)queryWrapper);
    }

    private int recordUserGuildLog(UserGuidePoJo record) {
        UserGuideLog guideLog = new UserGuideLog();
        guideLog.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        guideLog.setAppCode(record.getAppCode());
        guideLog.setModularCode(record.getModularCode());
        guideLog.setTenantId(record.getTenantId());
        guideLog.setUserId(record.getUserId());
        guideLog.setCode(record.getCode());
        guideLog.setSubKey(record.getSubKey());
        guideLog.setCreateDate(LocalDateTime.now());
        return this.userGuideLogMapper.insert((Object)guideLog);
    }

    private int updateUserGuideState(UserGuidePoJo guideInfo, String disableSource) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"state", (Object)guideInfo.getState());
        updateWrapper.set((Object)"disable_source", (Object)disableSource);
        updateWrapper.set((Object)"modify_date", (Object)LocalDateTime.now());
        updateWrapper.eq((Object)"user_id", (Object)guideInfo.getUserId());
        updateWrapper.eq((Object)"tenant_id", (Object)guideInfo.getTenantId());
        updateWrapper.eq((Object)"modular_code", (Object)guideInfo.getModularCode());
        updateWrapper.eq((Object)"code", (Object)guideInfo.getCode());
        updateWrapper.eq((Object)"app_code", (Object)guideInfo.getAppCode());
        updateWrapper.eq((Object)"sub_key", (Object)guideInfo.getSubKey());
        return this.userGuideInfoMapper.update(null, (Wrapper)updateWrapper);
    }
}

