/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.importstatistics.service.impl;

import com.alibaba.nacos.common.utils.MapUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadTemplateDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadTemplateReqDTO;
import com.digiwin.athena.atdm.importstatistics.entity.CellTypeContainer;
import com.digiwin.athena.atdm.importstatistics.entity.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.atdm.importstatistics.entity.valueobject.Dictionary;
import com.digiwin.athena.atdm.importstatistics.entity.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.atdm.importstatistics.entity.valueobject.MetaDataType;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelTypeEnum;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelUtil;
import com.digiwin.athena.base.application.service.importstatistics.service.DataEntryEspService;
import com.digiwin.athena.base.application.service.importstatistics.service.helpler.ExcelHelper;
import com.digiwin.athena.base.infrastructure.manager.abt.AbtService;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DataEntryMetaDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEntryMetaDataService.class);
    @Resource
    RestTemplate restTemplate;
    @Autowired
    ExcelHelper excelHelper;
    @Value(value="${themeMap.uri}")
    private String knowledgeGraphUrl;
    @Autowired
    DataEntryEspService espService;
    private final String HEADER_KEY = "key";
    private final String HEADER_NAME = "name";
    private final String METADATA_URL = "/restful/service/knowledgegraph/Action/Metadata?actionId={actionId}";
    private final String DICT_BATCH_URL = "/restful/service/knowledgegraph/Dict/FindDictByKeyList";
    private final String DICT_URL = "/restful/service/knowledgegraph/Dict/DictByKey?key={key}";
    private final String FILE_EXIST_URL = "/restful/service/knowledgegraph/File/FileId?key={key}&version={version}";
    private final String TEMPLATE_DOWNLOAD_URL = "/restful/service/knowledgegraph/File/DownloadTemplate?fileId={fileId}";
    private final String PRODUCT_NAME_URL = "/restful/service/knowledgegraph/Action/ProductName?serviceName={serviceName}";
    private final String ACTIVITY_NAME_URL = "/restful/service/knowledgegraph/task/activityNamesByCode?activityCode={activityCode}";
    private final String TEMPLATE_NAME = "template";
    private final String EXCEL_SUFFIX = ".xlsx";
    @Autowired
    AbtService abtService;

    public String getProductName(String token, String serviceName) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serviceName", serviceName);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Action/ProductName?serviceName={serviceName}", HttpMethod.GET, entity, DapResponse.class, parameters);
        if (result.getStatusCodeValue() == 200 && ((DapResponse)result.getBody()).getStatus() == 200) {
            String productName = (String)((DapResponse)result.getBody()).getResponse();
            return productName;
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0094.getErrCode(), (String)"\u672a\u627e\u5230\u5143\u6570\u636e");
    }

    public GetActionLocaleResponseDTO getActionMetaData(String actionId, String token, String locale) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        if (!StringUtils.isEmpty((String)locale)) {
            headers.add("locale", locale);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("actionId", actionId);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Action/Metadata?actionId={actionId}", HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<GetActionLocaleResponseDTO>>(){}, parameters);
        if (200 == result.getStatusCodeValue() && null != result.getBody() && 200 == ((DapResponse)result.getBody()).getStatus()) {
            return (GetActionLocaleResponseDTO)((DapResponse)result.getBody()).getResponse();
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0105.getErrCode(), (String)("\u8c03\u7528" + this.knowledgeGraphUrl + "knowledgegraph/Action/Metadata?actionId=" + actionId + "\u672a\u627e\u5230\u5143\u6570\u636e"));
    }

    public Map<String, List<Dictionary>> getDictByKeyList(List<String> keyList, String token, String securityToken, String locale) {
        if (CollectionUtils.isEmpty(keyList)) {
            return Collections.EMPTY_MAP;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("token", token);
        if (!StringUtils.isEmpty((String)securityToken)) {
            headers.add("security-token", securityToken);
        }
        if (!StringUtils.isEmpty((String)locale)) {
            headers.add("locale", locale);
        }
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("keyList", keyList);
        HttpEntity entity = new HttpEntity(parameters, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.knowledgeGraphUrl + "/restful/service/knowledgegraph/Dict/FindDictByKeyList", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<Map<String, List<Dictionary>>>>(){}, new Object[0]);
        if (200 == result.getStatusCodeValue() && null != result.getBody() && 200 == ((DapResponse)result.getBody()).getStatus()) {
            if (MapUtils.isEmpty((Map)((Map)((DapResponse)result.getBody()).getResponse()))) {
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0096.getErrCode(), (String)"\u672a\u627e\u5230\u5143\u6570\u636e");
            }
            return (Map)((DapResponse)result.getBody()).getResponse();
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0096.getErrCode(), (String)"\u672a\u627e\u5230\u5143\u6570\u636e");
    }

    public List<Map> getHeaders(String actionId, String userToken, String locale) {
        GetActionLocaleResponseDTO getActionLocaleResponseDTO = this.getActionMetaData(actionId, userToken, locale);
        return this.getHeaders(getActionLocaleResponseDTO);
    }

    public List<Map> getHeaders(GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = (ApiDataFieldLocaleMetadataDTO)getActionLocaleResponseDTO.getRequest().getParameters().get(0);
        LinkedList<Map> headers = new LinkedList<Map>();
        apiDataFieldLocaleMetadataDTO.getField().forEach(item -> {
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("key", item.getData_name());
            header.put("name", item.getDescription());
            headers.add(header);
        });
        return headers;
    }

    public Map<String, String> getResponseHeaders(GetActionLocaleResponseDTO getActionLocaleResponseDTO, List<String> keyList) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getResponse().getData();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        apiDataFieldLocaleMetadataDTO.getField().forEach(item -> {
            keyList.add(item.getData_name());
            headerMap.put(item.getData_name(), item.getDescription());
        });
        return headerMap;
    }

    public void downloadTemplate(String actionId, String token, String locale, String fileName, DownloadTemplateDTO downloadTemplateDTO, HttpServletResponse response) {
        response.setContentType(ExcelTypeEnum.XLSX.value());
        try {
            response.addHeader("Content-Disposition", "attachment;filename=" + (StringUtils.isEmpty((String)fileName) ? "template" : URLEncoder.encode(fileName, "UTF-8")) + ".xlsx");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("\u6587\u4ef6\u540d\u8f6c\u4e49\u5931\u8d25");
            response.addHeader("Content-Disposition", "attachment;filename=template.xlsx");
        }
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        byte[] fileBytes = this.abtService.downloadTemplate(actionId, token, locale, downloadTemplateDTO);
        if (null == fileBytes || fileBytes.length == 0) {
            log.error("\u4e0b\u8f7d\u7684\u6a21\u677f\u6587\u4ef6\u6d41\u4e3a\u7a7a\uff01");
            return;
        }
        try (ServletOutputStream out = response.getOutputStream();){
            out.write(fileBytes, 0, fileBytes.length);
            out.flush();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
    }

    public void downloadTemplateBatch(List<DownloadTemplateReqDTO> params, HttpServletResponse response, String token, String locale) {
        response.setContentType("application/zip");
        try {
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("templates.zip", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            response.addHeader("Content-Disposition", "attachment;filename=templates.zip");
        }
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        try (ByteArrayOutputStream zipOutStream = new ByteArrayOutputStream();
             ZipOutputStream zipOutputStream = new ZipOutputStream(zipOutStream);
             ServletOutputStream out = response.getOutputStream();){
            for (DownloadTemplateReqDTO e : params) {
                DownloadTemplateDTO downloadTemplateDTO = new DownloadTemplateDTO();
                downloadTemplateDTO.setActionInfo(e.getActionInfo());
                downloadTemplateDTO.setFileName(e.getFileName());
                downloadTemplateDTO.setRequiredFields(e.getRequiredFields());
                byte[] fileBytes = this.abtService.downloadTemplate(e.getActionId(), token, locale, downloadTemplateDTO);
                if (fileBytes == null || fileBytes.length <= 0) continue;
                zipOutputStream.putNextEntry(new ZipEntry(e.getFileName() + ".xlsx"));
                zipOutputStream.write(fileBytes);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.finish();
            out.write(zipOutStream.toByteArray());
            out.flush();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d ZIP \u5931\u8d25", (Throwable)e);
        }
    }

    private void createChildSheet(XSSFWorkbook wb, List<CellTypeContainer> businessKeyContainer, CellTypeContainer cellTypeContainerMain, String locale, Set<String> requiredFields) {
        String mainKey = cellTypeContainerMain.getKeyName();
        String mainKeyDescription = cellTypeContainerMain.getKeyDescription();
        XSSFSheet sheet = wb.createSheet(ExcelHelper.getSheetName(mainKey, mainKeyDescription, false));
        List cellTypes = cellTypeContainerMain.getChildren();
        List<CellTypeContainer> childBusinessKeyContainerList = this.getBusinessKeyContainer(cellTypes);
        this.excelHelper.addBkContainer(cellTypes, businessKeyContainer);
        this.createSheetHeader(wb, (Sheet)sheet, childBusinessKeyContainerList, cellTypes, locale, requiredFields);
    }

    private void createSheetHeader(XSSFWorkbook wb, Sheet sheet, List<CellTypeContainer> businessKeyContainer, List<CellTypeContainer> cellTypes, String locale, Set<String> requiredFields) {
        XSSFDataFormat fmt = wb.createDataFormat();
        int index = 0;
        for (int i = 0; i < cellTypes.size(); ++i) {
            MetaDataType metaDataType = cellTypes.get(i).getProtoType();
            CellTypeContainer cellTypeContainer = cellTypes.get(i);
            XSSFCellStyle cellStyle = wb.createCellStyle();
            switch (metaDataType) {
                case STRING: {
                    if (null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0) {
                        ExcelUtil.excelRuleStringLength((String)locale, (Sheet)sheet, (int)0, (int)cellTypeContainer.getPrecision()[0], (int)2, (int)65536, (int)index, (int)index);
                    }
                    cellStyle.setDataFormat(fmt.getFormat("@"));
                    sheet.setDefaultColumnStyle(index, (CellStyle)cellStyle);
                    break;
                }
                case NUMBER: {
                    ExcelUtil.excelRuleIsNumber((String)locale, (Sheet)sheet, (int)2, (int)65536, (int)index, (int)index);
                    break;
                }
                case DATE: {
                    cellStyle.setDataFormat(fmt.getFormat(cellTypeContainer.getDateFormat()));
                    sheet.setDefaultColumnStyle(index, (CellStyle)cellStyle);
                    ExcelUtil.excelRuleDateFormat((String)locale, (Sheet)sheet, (String)"1720-01-01", (String)"", (String)cellTypeContainer.getDateFormat(), (int)2, (int)65536, (int)index, (int)index);
                    break;
                }
                case OBJECT: {
                    if (cellTypeContainer.getArray().booleanValue() && !CollectionUtils.isEmpty(businessKeyContainer)) {
                        this.createChildSheet(wb, businessKeyContainer, cellTypeContainer, locale, requiredFields);
                        --index;
                    }
                    if (null == cellTypeContainer.getListEnum() || cellTypeContainer.getListEnum().length == 0) break;
                    ExcelUtil.excelRuleSelect((String)locale, (Sheet)sheet, (String[])cellTypeContainer.getListEnum(), (int)2, (int)65536, (int)index, (int)index);
                    break;
                }
                case BOOLEAN: {
                    ExcelUtil.excelRuleSelect((String)locale, (Sheet)sheet, (String[])cellTypeContainer.getListEnum(), (int)2, (int)65536, (int)index, (int)index);
                    break;
                }
                case ENUM: {
                    if (null == cellTypeContainer.getListEnum() || cellTypeContainer.getListEnum().length == 0) break;
                    ExcelUtil.excelRuleSelect((String)locale, (Sheet)sheet, (String[])cellTypeContainer.getListEnum(), (int)2, (int)65536, (int)index, (int)index);
                    break;
                }
            }
            ++index;
        }
        Row headRow1 = sheet.createRow(0);
        Row headRow2 = sheet.createRow(1);
        index = 0;
        for (int i = 0; i < cellTypes.size(); ++i) {
            if (cellTypes.get(i).getArray().booleanValue()) continue;
            Cell cell1 = headRow1.createCell(index);
            Cell cell2 = headRow2.createCell(index);
            if (!CollectionUtils.isEmpty(requiredFields) && requiredFields.contains(cellTypes.get(i).getKeyName())) {
                cell1.setCellValue((RichTextString)ExcelUtil.addRequiredMark((XSSFWorkbook)wb, (String)cellTypes.get(i).getKeyDescription()));
                cell2.setCellValue(cellTypes.get(i).getKeyName());
            } else {
                cell1.setCellValue(cellTypes.get(i).getKeyDescription());
                cell2.setCellValue(cellTypes.get(i).getKeyName());
            }
            ++index;
        }
    }

    private List<CellTypeContainer> getBusinessKeyContainer(List<CellTypeContainer> cellTypes) {
        LinkedList<CellTypeContainer> cellTypeContainers = new LinkedList<CellTypeContainer>();
        for (CellTypeContainer cellType : cellTypes) {
            if (!cellType.getBusinessKey().booleanValue()) continue;
            cellTypeContainers.add(cellType);
        }
        return cellTypeContainers;
    }

    public void downloadTemplate(String actionId, String token, String locale, String fileName, HttpServletResponse response) {
        this.downloadTemplate(actionId, token, locale, fileName, null, response);
    }

    public List<CellTypeContainer> getCellTypeContainers(List<ApiDataFieldLocaleMetadataDTO> field, String token, String securityToken, String locale, int depth) {
        LinkedList<CellTypeContainer> cellTypes = new LinkedList<CellTypeContainer>();
        List<String> keyList = field.stream().map(ApiDataFieldLocaleMetadataDTO::getEnum_key).collect(Collectors.toList());
        keyList.removeAll(Collections.singleton(null));
        Map<String, List<Dictionary>> dictionaryMap = this.getDictByKeyList(keyList, token, securityToken, locale);
        field.forEach(item -> {
            CellTypeContainer cellTypeContainer;
            switch (MetaDataType.valueOf((String)item.getData_type().toUpperCase())) {
                case NUMBER: 
                case NUMERIC: {
                    cellTypeContainer = new CellTypeContainer();
                    if (null != item.getEnum_key() && null != dictionaryMap.get(item.getEnum_key())) {
                        cellTypeContainer.setProtoType(MetaDataType.ENUM);
                        cellTypeContainer.setCellType(CellType.STRING);
                        List dictionaries = (List)dictionaryMap.get(item.getEnum_key());
                        String[] listEnum = this.parseListEnum(dictionaries);
                        cellTypeContainer.setListEnum(listEnum);
                        cellTypeContainer.setDictionaries(dictionaries);
                        break;
                    }
                    cellTypeContainer.setProtoType(MetaDataType.NUMBER);
                    cellTypeContainer.setCellType(CellType.NUMERIC);
                    int[] precision = this.parsePrecision((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setPrecision(precision);
                    break;
                }
                case DATE: 
                case DATETIME: 
                case TIME: {
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setProtoType(MetaDataType.DATE);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String dateFormat = this.parseDateFormat((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setDateFormat(dateFormat);
                    break;
                }
                case STRING: {
                    cellTypeContainer = new CellTypeContainer();
                    if (null != item.getEnum_key() && null != dictionaryMap.get(item.getEnum_key())) {
                        cellTypeContainer.setProtoType(MetaDataType.ENUM);
                        cellTypeContainer.setCellType(CellType.STRING);
                        List dictionaries = (List)dictionaryMap.get(item.getEnum_key());
                        String[] listEnum = this.parseListEnum(dictionaries);
                        cellTypeContainer.setListEnum(listEnum);
                        cellTypeContainer.setDictionaries(dictionaries);
                        break;
                    }
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setProtoType(MetaDataType.STRING);
                    cellTypeContainer.setCellType(CellType.STRING);
                    int[] precision = this.parsePrecision((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setPrecision(precision);
                    break;
                }
                case OBJECT: {
                    cellTypeContainer = new CellTypeContainer();
                    if (item.getIs_array()) {
                        cellTypeContainer.setChildren(this.getCellTypeContainers(item.getField(), token, securityToken, locale, depth + 1));
                    }
                    cellTypeContainer.setProtoType(MetaDataType.OBJECT);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String[] listEnum = this.parseListEnum((ApiDataFieldLocaleMetadataDTO)item);
                    cellTypeContainer.setListEnum(listEnum);
                    break;
                }
                case BOOLEAN: {
                    cellTypeContainer = new CellTypeContainer();
                    if (null != item.getEnum_key() && null != dictionaryMap.get(item.getEnum_key())) {
                        cellTypeContainer.setProtoType(MetaDataType.ENUM);
                        cellTypeContainer.setCellType(CellType.STRING);
                        List dictionaries = (List)dictionaryMap.get(item.getEnum_key());
                        String[] listEnum = this.parseListEnum(dictionaries);
                        cellTypeContainer.setListEnum(listEnum);
                        cellTypeContainer.setDictionaries(dictionaries);
                        break;
                    }
                    cellTypeContainer.setProtoType(MetaDataType.BOOLEAN);
                    cellTypeContainer.setCellType(CellType.STRING);
                    String[] listEnum = this.parseBooleanListEnum();
                    cellTypeContainer.setListEnum(listEnum);
                    break;
                }
                default: {
                    cellTypeContainer = new CellTypeContainer();
                    cellTypeContainer.setCellType(CellType.STRING);
                }
            }
            cellTypeContainer.setBusinessKey(Boolean.valueOf(item.getIs_businesskey()));
            cellTypeContainer.setArray(Boolean.valueOf(item.getIs_array()));
            cellTypeContainer.setKeyName(item.getData_name());
            cellTypeContainer.setKeyDescription(item.getDescription());
            cellTypes.add(cellTypeContainer);
        });
        return cellTypes;
    }

    private String[] parseListEnum(List<Dictionary> dictionaries) {
        List<String> select = dictionaries.stream().map(d -> d.getCode() + "." + d.getValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(select)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0100.getErrCode(), (String)"\u4e0b\u62c9\u5b57\u5178\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return select.toArray(new String[0]);
    }

    public Map<String, CellTypeContainer> getResponseCellTypeContainers(GetActionLocaleResponseDTO getActionLocaleResponseDTO, String token, String locale) {
        ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO = getActionLocaleResponseDTO.getResponse().getData();
        if (CollectionUtils.isEmpty((Collection)apiDataFieldLocaleMetadataDTO.getField())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0102.getErrCode(), (String)"\u5143\u6570\u636e\u51fa\u53c2\u4e3a\u7a7a");
        }
        List keyList = apiDataFieldLocaleMetadataDTO.getField().stream().map(ApiDataFieldLocaleMetadataDTO::getEnum_key).collect(Collectors.toList());
        keyList.removeAll(Collections.singleton(null));
        List<CellTypeContainer> cellTypeContainers = this.getCellTypeContainers(apiDataFieldLocaleMetadataDTO.getField(), token, null, locale, 1);
        Map<String, CellTypeContainer> cellTypeContainerMap = cellTypeContainers.stream().collect(Collectors.toMap(CellTypeContainer::getKeyName, Function.identity()));
        this.parseCellTypeContainerMapDict(cellTypeContainerMap);
        return cellTypeContainerMap;
    }

    private void parseCellTypeContainerMapDict(Map<String, CellTypeContainer> cellTypeContainerMap) {
        cellTypeContainerMap.forEach((k, v) -> {
            if (!CollectionUtils.isEmpty((Collection)v.getDictionaries())) {
                Map<String, String> dictMap = v.getDictionaries().stream().collect(Collectors.toMap(Dictionary::getCode, Dictionary::getValue, (entity1, entity2) -> entity1));
                v.setDictMap(dictMap);
            }
            if (!CollectionUtils.isEmpty((Collection)v.getChildren())) {
                v.getChildren().forEach(item -> {
                    if (!CollectionUtils.isEmpty((Collection)item.getDictionaries())) {
                        Map<String, String> dictMapInner = item.getDictionaries().stream().collect(Collectors.toMap(Dictionary::getCode, Dictionary::getValue, (entity1, entity2) -> entity1));
                        item.setDictMap(dictMapInner);
                    }
                });
            }
        });
    }

    private String[] parseBooleanListEnum() {
        return new String[]{"TRUE", "FALSE"};
    }

    private String[] parseListEnum(ApiDataFieldLocaleMetadataDTO item) {
        return null;
    }

    private String parseDateFormat(ApiDataFieldLocaleMetadataDTO item) {
        String locale;
        Object multiLanguageDTO = null;
        if (null == multiLanguageDTO) {
            switch (MetaDataType.valueOf((String)item.getData_type().toUpperCase())) {
                case DATETIME: {
                    return "yyyy-MM-dd HH:mm:ss";
                }
                case TIME: {
                    return "HH:mm:ss";
                }
                case DATE: {
                    return "yyyy-MM-dd";
                }
            }
            return "yyyy-MM-dd";
        }
        switch (locale = LocaleContextHolder.getLocale().toString()) {
            case "zh_TW": {
                return multiLanguageDTO.getZh_TW();
            }
            case "zh_CN": {
                return multiLanguageDTO.getZh_CN();
            }
            case "en_US": {
                return multiLanguageDTO.getEn();
            }
        }
        return multiLanguageDTO.getZh_CN();
    }

    private int[] parsePrecision(ApiDataFieldLocaleMetadataDTO metadataDTO) {
        if (!StringUtils.isEmpty((String)metadataDTO.getPrecision())) {
            String precision = metadataDTO.getPrecision();
            if (StringUtils.isEmpty((String)precision)) {
                return new int[0];
            }
            if (precision.indexOf(",") != -1) {
                String[] values = precision.substring(precision.indexOf("(") + 1, precision.indexOf(")")).split(",");
                if (StringUtils.isEmpty((String)values[0]) || StringUtils.isEmpty((String)values[1]) || "null".equals(values[0]) || "null".equals(values[1])) {
                    return new int[0];
                }
                int[] precisionValue = new int[]{Integer.valueOf(values[0]), Integer.valueOf(values[1])};
                return precisionValue;
            }
            int[] precisionValue = new int[]{Integer.valueOf(precision)};
            return precisionValue;
        }
        return new int[0];
    }
}

