/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.principal;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.application.meta.request.principal.TaskTypeQueryReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoSaveReq;
import com.digiwin.athena.base.application.meta.response.audc.TaskTypeQueryResp;
import com.digiwin.athena.base.application.service.principal.PrincipalTaskTypeService;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocEmpInfoDTO;
import com.digiwin.athena.base.infrastructure.mapper.audc.principal.PrincipalTaskTypeMapper;
import com.digiwin.athena.base.infrastructure.meta.bo.principal.ThePrincipalTaskNum;
import com.digiwin.athena.base.sdk.audc.application.service.principal.QueryPrincipalTaskTypeService;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.ThePrincipalTaskType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrincipalTaskTypeServiceImpl
implements PrincipalTaskTypeService {
    @Autowired
    private PrincipalTaskTypeMapper principalTaskTypeMapper;
    @Autowired
    private QueryPrincipalTaskTypeService queryPrincipalTaskTypeService;
    @Resource
    private MessageUtils messageUtils;

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public void saveTaskType(String agentId, String userId, List<String> taskDefCodes, String tenantId, List<String> calendarTaskCodes) {
        List insertList;
        this.principalTaskTypeMapper.batchDelete(Arrays.asList(userId), LocalDateTime.now(), tenantId);
        ArrayList allInsertList = new ArrayList();
        if (CollectionUtils.isNotEmpty(taskDefCodes)) {
            insertList = taskDefCodes.stream().map(taskDefCode -> new ThePrincipalTaskType(userId, agentId, tenantId, taskDefCode, Integer.valueOf(0))).collect(Collectors.toList());
            allInsertList.addAll(insertList);
        }
        if (CollectionUtils.isNotEmpty(calendarTaskCodes)) {
            insertList = calendarTaskCodes.stream().map(taskDefCode -> new ThePrincipalTaskType(userId, agentId, tenantId, taskDefCode, Integer.valueOf(1))).collect(Collectors.toList());
            allInsertList.addAll(insertList);
        }
        if (CollectionUtils.isNotEmpty(allInsertList)) {
            this.principalTaskTypeMapper.batchInsert(allInsertList);
        }
    }

    @Override
    public List<TaskTypeQueryResp> queryTaskType(TaskTypeQueryReq taskTypeQueryReq, String tenantId) {
        if (Objects.isNull(taskTypeQueryReq)) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.null"));
        }
        if (CollectionUtils.isEmpty(taskTypeQueryReq.getThePrincipalId())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.thePrincipalIdList.null"));
        }
        List queryList = this.queryPrincipalTaskTypeService.queryPrincipalTaskType(tenantId, taskTypeQueryReq.getThePrincipalId(), taskTypeQueryReq.getAgentId(), taskTypeQueryReq.getTaskDefCode());
        if (CollectionUtils.isEmpty((Collection)queryList)) {
            return Collections.emptyList();
        }
        List<TaskTypeQueryResp> response = queryList.stream().map(item -> new TaskTypeQueryResp((ThePrincipalTaskType)item)).collect(Collectors.toList());
        return response;
    }

    @Override
    public List<ThePrincipalTaskNum> queryTaskTypeNum(List<EocEmpInfoDTO> agentEmpList, String tenantId) {
        if (CollectionUtils.isEmpty(agentEmpList)) {
            return null;
        }
        return this.principalTaskTypeMapper.queryTaskTypeNum(agentEmpList, tenantId);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public void batchSaveTaskType(List<ProxyInfoSaveReq> needSaveList, String tenantId) {
        if (CollectionUtils.isEmpty(needSaveList)) {
            return;
        }
        List userIds = needSaveList.stream().map(ProxyInfoSaveReq::getUserId).collect(Collectors.toList());
        this.principalTaskTypeMapper.batchDelete(userIds, LocalDateTime.now(), tenantId);
        ArrayList allInsertList = new ArrayList();
        for (ProxyInfoSaveReq proxyInfoSaveReq : needSaveList) {
            List insertList;
            if (CollectionUtils.isNotEmpty(proxyInfoSaveReq.getTaskDefCodes())) {
                insertList = proxyInfoSaveReq.getTaskDefCodes().stream().map(taskDefCode -> new ThePrincipalTaskType(proxyInfoSaveReq.getUserId(), proxyInfoSaveReq.getAgentId(), tenantId, taskDefCode, Integer.valueOf(0))).collect(Collectors.toList());
                allInsertList.addAll(insertList);
            }
            if (!CollectionUtils.isNotEmpty(proxyInfoSaveReq.getCalendarTaskCodes())) continue;
            insertList = proxyInfoSaveReq.getCalendarTaskCodes().stream().map(taskDefCode -> new ThePrincipalTaskType(proxyInfoSaveReq.getUserId(), proxyInfoSaveReq.getAgentId(), tenantId, taskDefCode, Integer.valueOf(1))).collect(Collectors.toList());
            allInsertList.addAll(insertList);
        }
        if (CollectionUtils.isNotEmpty(allInsertList)) {
            this.principalTaskTypeMapper.batchInsert(allInsertList);
        }
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public void batchDeleteTaskType(List<String> clearList, String tenantId) {
        if (CollectionUtils.isNotEmpty(clearList)) {
            this.principalTaskTypeMapper.batchDelete(clearList, LocalDateTime.now(), tenantId);
        }
    }
}

