/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.proxyinfo;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.application.converter.DataConverter;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentChangeBatchEvent;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentChangeEvent;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentClearBatchEvent;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentClearEvent;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoRemoveReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoSaveReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.SaveSubordinateReq;
import com.digiwin.athena.base.application.service.principal.PrincipalTaskTypeService;
import com.digiwin.athena.base.application.service.proxyinfo.ProxyInfoService;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.eoc.BaseEocService;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocEmpInfoDTO;
import com.digiwin.athena.base.infrastructure.meta.bo.principal.ThePrincipalTaskNum;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProxyInfoServiceImpl
implements ProxyInfoService {
    @Autowired
    private PrincipalTaskTypeService principalTaskTypeService;
    @Resource
    private BaseEocService eocService;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    private AsyncEventBus asyncEventBus;

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="baseAudcDataSourceTransactionManager")
    public void saveProxyInfo(ProxyInfoSaveReq proxyInfoSaveReq, AuthoredUser user) {
        this.validateParam(proxyInfoSaveReq);
        if (BooleanUtils.isTrue((Boolean)proxyInfoSaveReq.getNeedSaveTaskDefCode())) {
            this.principalTaskTypeService.saveTaskType(proxyInfoSaveReq.getAgentId(), proxyInfoSaveReq.getUserId(), proxyInfoSaveReq.getTaskDefCodes(), user.getTenantId(), proxyInfoSaveReq.getCalendarTaskCodes());
        }
        if (BooleanUtils.isTrue((Boolean)proxyInfoSaveReq.getNeedSendMessage())) {
            this.eocService.empAgentChange(DataConverter.INSTANCE.toEmpAgentSaveReq(proxyInfoSaveReq), user);
            if (BooleanUtils.isTrue((Boolean)proxyInfoSaveReq.getIsAthena())) {
                MessageAgentChangeEvent event = new MessageAgentChangeEvent(proxyInfoSaveReq.getUserId(), proxyInfoSaveReq.getAgentId(), proxyInfoSaveReq.getAgentBeginDate(), proxyInfoSaveReq.getAgentEndDate(), user.getToken());
                this.asyncEventBus.post((Object)event);
            }
        }
    }

    private void validateParam(ProxyInfoSaveReq proxyInfoSaveReq) {
        if (Objects.isNull(proxyInfoSaveReq)) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.null"));
        }
        if (StringUtils.isEmpty((CharSequence)proxyInfoSaveReq.getUserId())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.userId.null"));
        }
        if (StringUtils.isEmpty((CharSequence)proxyInfoSaveReq.getAgentId())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.agentId.null"));
        }
        if (StringUtils.isEmpty((CharSequence)proxyInfoSaveReq.getAgentBeginDate()) || StringUtils.isEmpty((CharSequence)proxyInfoSaveReq.getAgentEndDate())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.agentDate.null"));
        }
        if (Objects.isNull(proxyInfoSaveReq.getNeedSaveTaskDefCode()) || Objects.isNull(proxyInfoSaveReq.getNeedSendMessage())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.flag.null"));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="baseAudcDataSourceTransactionManager")
    public void removeProxyInfo(ProxyInfoRemoveReq proxyInfoRemoveReq, AuthoredUser user) {
        if (Objects.isNull(proxyInfoRemoveReq)) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.null"));
        }
        if (StringUtils.isEmpty((CharSequence)proxyInfoRemoveReq.getUserId())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.userId.null"));
        }
        if (StringUtils.isEmpty((CharSequence)proxyInfoRemoveReq.getAgentId())) {
            return;
        }
        this.principalTaskTypeService.batchDeleteTaskType(Arrays.asList(proxyInfoRemoveReq.getUserId()), user.getTenantId());
        this.eocService.empAgentClear(proxyInfoRemoveReq.getUserId(), user);
        if (BooleanUtils.isTrue((Boolean)proxyInfoRemoveReq.getIsAthena())) {
            MessageAgentClearEvent event = new MessageAgentClearEvent(proxyInfoRemoveReq.getUserId(), user.getToken());
            this.asyncEventBus.post((Object)event);
        }
    }

    @Override
    public List<EocEmpInfoDTO> querySubordinate(AuthoredUser user) {
        JSONArray departmentArray = this.eocService.queryCurrentTenantAllDepartment();
        if (CollectionUtils.isEmpty((Collection)departmentArray)) {
            return departmentArray;
        }
        List<EocEmpInfoDTO> allEmps = this.queryEocEmpInfoList(departmentArray, user.getUserId());
        if (CollectionUtils.isEmpty(allEmps)) {
            return allEmps;
        }
        List<EocEmpInfoDTO> agentEmpList = allEmps.stream().filter(emp -> StringUtils.isNotEmpty((CharSequence)emp.getAgentId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(agentEmpList)) {
            List<ThePrincipalTaskNum> taskNumList = this.principalTaskTypeService.queryTaskTypeNum(agentEmpList, user.getTenantId());
            this.setTaskNum(allEmps, taskNumList);
        }
        return allEmps;
    }

    private void setTaskNum(List<EocEmpInfoDTO> allEmps, List<ThePrincipalTaskNum> taskNumList) {
        if (CollectionUtils.isEmpty(taskNumList)) {
            allEmps.forEach(emp -> {
                if (StringUtils.isNotEmpty((CharSequence)emp.getAgentId())) {
                    emp.setTaskNum(Long.valueOf(0L));
                }
            });
            return;
        }
        Map<String, Long> taskNumMap = taskNumList.stream().collect(Collectors.toMap(e -> e.getThePrincipalId() + "_" + e.getAgentId(), ThePrincipalTaskNum::getTaskNum, (key1, key2) -> key2));
        for (EocEmpInfoDTO emp2 : allEmps) {
            if (!StringUtils.isNotEmpty((CharSequence)emp2.getAgentId())) continue;
            Long num = taskNumMap.get(emp2.getUserId() + "_" + emp2.getAgentId());
            emp2.setTaskNum(Long.valueOf(Objects.isNull(num) ? 0L : num));
        }
    }

    private List<EocEmpInfoDTO> queryEocEmpInfoList(JSONArray departmentArray, String userId) {
        ArrayList<EocEmpInfoDTO> allEmps = new ArrayList<EocEmpInfoDTO>();
        for (int i = 0; i < departmentArray.size(); ++i) {
            List emps;
            JSONObject department = departmentArray.getJSONObject(i);
            if (!department.containsKey((Object)"directorId") || Objects.equals(userId, department.getString("directorId")) || !StringUtils.isNotEmpty((CharSequence)department.getString("sid")) || !CollectionUtils.isNotEmpty((Collection)(emps = this.eocService.queryMembersOfTheDepartment(department.getString("sid"))))) continue;
            emps.forEach(emp -> {
                emp.setDeptSid(Long.valueOf(department.getLong("sid")));
                emp.setDeptid(department.getString("id"));
                emp.setDeptName(department.getString("name"));
            });
            allEmps.addAll(emps);
        }
        return allEmps;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="baseAudcDataSourceTransactionManager")
    public void saveSubordinate(SaveSubordinateReq saveSubordinateReq, AuthoredUser user) {
        List<ProxyInfoSaveReq> needSendMsgToEocList;
        List<String> clearList;
        if (Objects.isNull(saveSubordinateReq) || CollectionUtils.isEmpty(saveSubordinateReq.getSaveList())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.null"));
        }
        for (ProxyInfoSaveReq proxyInfoSaveReq : saveSubordinateReq.getSaveList()) {
            this.validateParam(proxyInfoSaveReq);
        }
        List<ProxyInfoSaveReq> saveList = saveSubordinateReq.getSaveList();
        List<ProxyInfoSaveReq> needSaveList = saveList.stream().filter(e -> BooleanUtils.isTrue((Boolean)e.getNeedSaveTaskDefCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needSaveList)) {
            this.principalTaskTypeService.batchSaveTaskType(needSaveList, user.getTenantId());
        }
        if (CollectionUtils.isNotEmpty(clearList = saveSubordinateReq.getClearList())) {
            this.principalTaskTypeService.batchDeleteTaskType(saveSubordinateReq.getClearList(), user.getTenantId());
        }
        if (CollectionUtils.isNotEmpty(needSendMsgToEocList = saveList.stream().filter(e -> BooleanUtils.isTrue((Boolean)e.getNeedSendMessage())).collect(Collectors.toList()))) {
            this.eocService.batchEmpAgentChange(needSendMsgToEocList.stream().map(needSendMsgToEoc -> DataConverter.INSTANCE.toEmpAgentSaveReq((ProxyInfoSaveReq)needSendMsgToEoc)).collect(Collectors.toList()), user);
        }
        if (CollectionUtils.isNotEmpty(needSendMsgToEocList)) {
            MessageAgentChangeBatchEvent event = new MessageAgentChangeBatchEvent(needSendMsgToEocList, user.getToken());
            this.asyncEventBus.post((Object)event);
        }
        if (CollectionUtils.isNotEmpty(clearList)) {
            MessageAgentClearBatchEvent batchEvent = new MessageAgentClearBatchEvent(clearList, user);
            this.asyncEventBus.post((Object)batchEvent);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="baseAudcDataSourceTransactionManager")
    public void removeSubordinate(ProxyInfoRemoveReq proxyInfoRemoveReq, AuthoredUser user) {
        if (Objects.isNull(proxyInfoRemoveReq)) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.null"));
        }
        if (StringUtils.isEmpty((CharSequence)proxyInfoRemoveReq.getUserId())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.param.userId.null"));
        }
        this.principalTaskTypeService.batchDeleteTaskType(Arrays.asList(proxyInfoRemoveReq.getUserId()), user.getTenantId());
        this.eocService.empAgentClear(proxyInfoRemoveReq.getUserId(), user);
        MessageAgentClearEvent event = new MessageAgentClearEvent(proxyInfoRemoveReq.getUserId(), user.getToken());
        this.asyncEventBus.post((Object)event);
    }
}

