/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.tenantauth;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.base.application.service.tenantauth.ITenantAuthService;
import com.digiwin.athena.base.infrastructure.constant.TenantEnum;
import com.digiwin.athena.base.infrastructure.manager.iam.service.BaseIamService;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantAuthServiceImpl
implements ITenantAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAuthServiceImpl.class);
    @Autowired
    private BaseIamService baseIamService;

    @Override
    public Map<String, String> getTargetTenantAndUser(AuthoredUser authoredUser, String email, String phone) {
        log.info("External customer email registration opens personal tenant and authorizes Athena begin, email:{}, phone:{}", (Object)email, (Object)phone);
        Map tenantAuthMap = this.baseIamService.getTenantAuth(authoredUser, email, phone, "Athena", Integer.valueOf(TenantEnum.INDIVIDUAL.getType()));
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Integer status = MapUtils.getInteger((Map)tenantAuthMap, (Object)"status");
        if (status == -1) {
            return null;
        }
        if (status == 0) {
            Map registerMap = this.baseIamService.registerTenant(authoredUser, email, phone, "Athena", "", "athena_light_01");
            if (MapUtils.isNotEmpty((Map)registerMap)) {
                resultMap.put("individualTenantId", (String)registerMap.get("id"));
                resultMap.put("userId", (String)registerMap.get("userId"));
            }
        } else if (status == 1) {
            Boolean isTenantAuth = Boolean.valueOf(tenantAuthMap.get("isTenantAuth").toString());
            Boolean authorizeUserResult = this.baseIamService.authorizeUser(authoredUser, tenantAuthMap.get("tenantId").toString(), email, phone, "Athena", "", "athena_light_01", isTenantAuth);
            if (authorizeUserResult.booleanValue()) {
                resultMap.put("individualTenantId", tenantAuthMap.get("tenantId").toString());
                resultMap.put("userId", tenantAuthMap.get("userId").toString());
            }
        } else if (status == 2) {
            resultMap.put("individualTenantId", tenantAuthMap.get("tenantId").toString());
            resultMap.put("userId", tenantAuthMap.get("userId").toString());
        }
        log.info("External customer email registration opens personal tenant and authorizes Athena end, result:{}", (Object)JsonUtils.objectToString(resultMap));
        return resultMap;
    }
}

