/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.userdefined;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserOperationMsgEvent;
import com.digiwin.athena.base.application.meta.request.userdefined.UserPageModelBodyDTO;
import com.digiwin.athena.base.application.meta.response.userdefined.TakeUpRecordDTO;
import com.digiwin.athena.base.application.meta.response.userdefined.UserPageModelRespDTO;
import com.digiwin.athena.base.application.service.userdefined.UserPageModelParentService;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.constant.Constants;
import com.digiwin.athena.base.infrastructure.manager.aim.BaseAimService;
import com.digiwin.athena.base.infrastructure.manager.aim.model.MessageDO;
import com.digiwin.athena.base.infrastructure.meta.po.userdefined.UserOperationRecordDTO;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserPageModelBaseDataService
extends UserPageModelParentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserPageModelBaseDataService.class);
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private BaseAimService baseAimService;

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public UserPageModelRespDTO getEdit(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        ArrayList<TakeUpRecordDTO> takeUpRecordDTOS;
        log.info("getEdit-start-{} ", (Object)this.genLogStr(authoredUser, pageModelBodyDTO));
        UserPageModelRespDTO respDTO = new UserPageModelRespDTO();
        if (!super.isCheckItem(pageModelBodyDTO)) {
            return respDTO;
        }
        try {
            List<UserOperationRecordDTO> userOperationRecordDTOS = super.getTakeUpUser(this.buildParams(authoredUser, pageModelBodyDTO));
            takeUpRecordDTOS = super.recordNoTakeUpOperation(this.buildNewOperationUser("0", authoredUser, pageModelBodyDTO), userOperationRecordDTOS);
        }
        catch (Exception e) {
            log.error("getEdit exception:{}", (Throwable)e);
            takeUpRecordDTOS = new ArrayList();
        }
        log.info("getEdit-end-{} ", (Object)this.genLogStr(authoredUser, pageModelBodyDTO));
        respDTO.setList(takeUpRecordDTOS);
        return respDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public UserPageModelRespDTO updateEdit(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        UserPageModelRespDTO respDTO = new UserPageModelRespDTO();
        log.info("updateEdit-start-{} ", (Object)this.genLogStr(authoredUser, pageModelBodyDTO));
        if (!super.isCheckItem(pageModelBodyDTO)) {
            respDTO.setResult(true);
            return respDTO;
        }
        if (!super.getLock(authoredUser, pageModelBodyDTO)) {
            log.error("\u83b7\u53d6\u5360\u7528\u9501\u5931\u8d25\uff1a{}", (Object)JsonUtils.objectToString((Object)pageModelBodyDTO));
            throw AudcErrorCodeEnum.PAGE_MODEL_GET_EDIT.getBusinessException(String.format(this.messageUtils.getMessage("pageModel.getLock"), new Object[0]));
        }
        try {
            List<UserOperationRecordDTO> takeUpUserList = super.getTakeUpUser(this.buildParams(authoredUser, pageModelBodyDTO));
            List<UserOperationRecordDTO> newTakeUpUserList = this.buildNewOperationUserList("1", authoredUser, pageModelBodyDTO);
            if (!super.recordTakeUpOperation(newTakeUpUserList, takeUpUserList)) {
                super.releaseLock(authoredUser, pageModelBodyDTO);
                respDTO.setResult(false);
                UserPageModelRespDTO userPageModelRespDTO = respDTO;
                return userPageModelRespDTO;
            }
            List<UserOperationRecordDTO> noTakeUpList = super.queryEffectiveRecords(this.buildQueryNoTakeUpParams(authoredUser, pageModelBodyDTO));
            if (CollectionUtils.isEmpty(noTakeUpList)) {
                respDTO.setResult(true);
                UserPageModelRespDTO userPageModelRespDTO = respDTO;
                return userPageModelRespDTO;
            }
            List<String> userIdList = noTakeUpList.stream().map(UserOperationRecordDTO::getUserId).distinct().collect(Collectors.toList());
            log.info("\u7528\u6237{}\u5360\u7528\u6210\u529f\uff0c\u5e76\u901a\u77e5\u5176\u4ed6\u975e\u5360\u7528\u8005{}", (Object)authoredUser.getUserId(), userIdList);
            this.sendMessageToClient(this.processMsgEvent(null, newTakeUpUserList, "baseDataEntry", "takeUp"), userIdList);
        }
        catch (Exception e) {
            log.error("updateEdit exception:{}", (Throwable)e);
            respDTO.setResult(false);
            UserPageModelRespDTO userPageModelRespDTO = respDTO;
            return userPageModelRespDTO;
        }
        finally {
            super.releaseLock(authoredUser, pageModelBodyDTO);
        }
        log.info("updateEdit-end-{} ", (Object)this.genLogStr(authoredUser, pageModelBodyDTO));
        respDTO.setResult(true);
        return respDTO;
    }

    @Override
    public UserOperationMsgEvent processMsgEvent(String token, List<UserOperationRecordDTO> newTakeUpUserList, String msgType, String msgCategory) {
        if (CollectionUtils.isEmpty(newTakeUpUserList)) {
            log.info("processMsgEvent newTakeUpUserList is empty!");
            return null;
        }
        UserOperationRecordDTO currentUser = newTakeUpUserList.get(0);
        UserOperationMsgEvent userOperationMsgEvent = new UserOperationMsgEvent();
        userOperationMsgEvent.setPageCode(currentUser.getPageCode());
        userOperationMsgEvent.setPageType(currentUser.getPageType());
        userOperationMsgEvent.setTenantId(currentUser.getTenantId());
        userOperationMsgEvent.setTimestamp(new Date());
        userOperationMsgEvent.setId(UUID.randomUUID().toString());
        userOperationMsgEvent.setMsgType(msgType);
        userOperationMsgEvent.setMsgCategory(msgCategory);
        userOperationMsgEvent.setToken(token);
        ArrayList<TakeUpRecordDTO> takeUpRecordDTOS = new ArrayList<TakeUpRecordDTO>();
        newTakeUpUserList.forEach(item -> {
            TakeUpRecordDTO newItem = new TakeUpRecordDTO();
            BeanUtils.copyProperties((Object)item, (Object)newItem);
            takeUpRecordDTOS.add(newItem);
        });
        userOperationMsgEvent.setTakeUpRecordList(takeUpRecordDTOS);
        return userOperationMsgEvent;
    }

    @Override
    public void sendMessageToClient(UserOperationMsgEvent userOperationMsgEvent, List<String> userIdList) {
        if (null == userOperationMsgEvent) {
            log.info("sendMessageToClient userOperationMsgEvent is null!");
            return;
        }
        try {
            MessageDO messageDO = new MessageDO();
            messageDO.setContent((Object)userOperationMsgEvent);
            messageDO.setType(userOperationMsgEvent.getMsgType());
            messageDO.setCategory(userOperationMsgEvent.getMsgCategory());
            messageDO.setSendDate(LocalDateTime.now());
            messageDO.setGid(UUID.randomUUID().toString());
            messageDO.setTenantId(userOperationMsgEvent.getTenantId());
            this.baseAimService.sendMessageToClient(userOperationMsgEvent.getToken(), messageDO.getTenantId(), userIdList, messageDO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u63a8\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private String genLogStr(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        if (null == authoredUser) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(authoredUser.getUserId()).append("-").append(authoredUser.getTenantId());
        if (null != pageModelBodyDTO) {
            sb.append("-").append(pageModelBodyDTO);
        }
        return sb.toString();
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public Boolean deleteEdit(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        log.info("deleteEdit-start-{}", (Object)this.genLogStr(authoredUser, pageModelBodyDTO));
        if (!super.isCheckItem(pageModelBodyDTO)) {
            return true;
        }
        try {
            List<UserOperationRecordDTO> deleteUserOperationList = this.buildNewOperationUserList(null, authoredUser, pageModelBodyDTO);
            Map<String, Object> params = this.buildDeleteParams(authoredUser, pageModelBodyDTO);
            int result = super.batchDeleteTakeUpUser(params);
            if (result <= 0) {
                log.error("deleteEdit result <=0!");
                return true;
            }
            List<UserOperationRecordDTO> noTakeUpList = this.queryEffectiveRecords(this.buildQueryNoTakeUpParams(authoredUser, pageModelBodyDTO));
            if (CollectionUtils.isEmpty(noTakeUpList)) {
                return true;
            }
            List<String> userIdList = noTakeUpList.stream().map(UserOperationRecordDTO::getUserId).distinct().collect(Collectors.toList());
            log.info("\u7528\u6237{}\u53d6\u6d88\u5360\u7528\u6210\u529f\uff0c\u5e76\u901a\u77e5\u5176\u4ed6\u975e\u5360\u7528\u8005{}", (Object)authoredUser.getUserId(), userIdList);
            this.sendMessageToClient(this.processMsgEvent(null, deleteUserOperationList, "baseDataEntry", "release"), userIdList);
        }
        catch (Exception e) {
            log.error("deleteEdit exception:{}", (Throwable)e);
            return false;
        }
        log.info("deleteEdit-end-{} ", (Object)this.genLogStr(authoredUser, pageModelBodyDTO));
        return true;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public Boolean reportStatus(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        log.info("reportStatus-start-{} ", (Object)this.genLogStr(authoredUser, pageModelBodyDTO));
        if (!super.isCheckItem(pageModelBodyDTO)) {
            return true;
        }
        try {
            UserOperationRecordDTO userPageModeDTO = new UserOperationRecordDTO();
            userPageModeDTO.setUserId(authoredUser.getUserId());
            userPageModeDTO.setTenantId(authoredUser.getTenantId());
            userPageModeDTO.setPageType(pageModelBodyDTO.getType());
            userPageModeDTO.setPageCode(pageModelBodyDTO.getActivityCode());
            userPageModeDTO.setClientId(pageModelBodyDTO.getClientId());
            userPageModeDTO.setUpdateTime(LocalDateTime.now());
            if (super.updateUserOperationRecord(userPageModeDTO) <= 0) {
                log.error("reportStatus fail,userPageModeDTO\uff1a{}", (Object)JsonUtils.objectToString((Object)userPageModeDTO));
                return false;
            }
        }
        catch (Exception e) {
            log.error("reportStatus exception:{}", (Throwable)e);
            return false;
        }
        log.info("reportStatus-end-{} ", (Object)this.genLogStr(authoredUser, pageModelBodyDTO));
        return true;
    }

    private UserOperationRecordDTO buildNewOperationUser(String takeUp, AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        UserOperationRecordDTO newOperationUser = new UserOperationRecordDTO();
        newOperationUser.setUserId(authoredUser.getUserId());
        newOperationUser.setUserName(authoredUser.getUserName());
        newOperationUser.setPageCode(pageModelBodyDTO.getActivityCode());
        newOperationUser.setTenantId(authoredUser.getTenantId());
        newOperationUser.setPageType(pageModelBodyDTO.getType());
        newOperationUser.setTakeUp(takeUp);
        newOperationUser.setClientId(pageModelBodyDTO.getClientId());
        LocalDateTime now = LocalDateTime.now();
        newOperationUser.setCreateTime(now);
        newOperationUser.setUpdateTime(now);
        return newOperationUser;
    }

    private List<UserOperationRecordDTO> buildNewOperationUserList(String takeUp, AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        ArrayList<UserOperationRecordDTO> takeUpUserList = new ArrayList<UserOperationRecordDTO>();
        LocalDateTime now = LocalDateTime.now();
        if (CollectionUtils.isEmpty(pageModelBodyDTO.getBusinessKeys())) {
            return super.queryEffectiveRecords(this.buildQueryTakeUpForReleaseAllParams(authoredUser, pageModelBodyDTO));
        }
        for (String businessKey : pageModelBodyDTO.getBusinessKeys()) {
            UserOperationRecordDTO newOperationUser = new UserOperationRecordDTO();
            newOperationUser.setId(SnowflakeIdWorker.getInstance().newId());
            newOperationUser.setUserId(authoredUser.getUserId());
            newOperationUser.setUserName(authoredUser.getUserName());
            newOperationUser.setPageCode(pageModelBodyDTO.getActivityCode());
            newOperationUser.setTenantId(authoredUser.getTenantId());
            newOperationUser.setPageType(pageModelBodyDTO.getType());
            newOperationUser.setTakeUp(takeUp);
            newOperationUser.setBusinessKey(businessKey);
            newOperationUser.setClientId(pageModelBodyDTO.getClientId());
            newOperationUser.setCreateTime(now);
            newOperationUser.setUpdateTime(now);
            takeUpUserList.add(newOperationUser);
        }
        return takeUpUserList;
    }

    @Override
    protected Map<String, Object> buildParams(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        HashMap params = Maps.newHashMap();
        params.put("tenantId", authoredUser.getTenantId());
        params.put("pageType", pageModelBodyDTO.getType());
        params.put("pageCode", pageModelBodyDTO.getActivityCode());
        params.put("updateTime", LocalDateTime.now().minus(Constants.USER_OPERATION_TTL, ChronoUnit.SECONDS));
        if (!CollectionUtils.isEmpty(pageModelBodyDTO.getBusinessKeys())) {
            params.put("businessKeys", pageModelBodyDTO.getBusinessKeys());
        }
        return params;
    }

    protected Map<String, Object> buildQueryNoTakeUpParams(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        HashMap params = Maps.newHashMap();
        params.put("tenantId", authoredUser.getTenantId());
        params.put("pageType", pageModelBodyDTO.getType());
        params.put("pageCode", pageModelBodyDTO.getActivityCode());
        params.put("updateTime", LocalDateTime.now().minus(Constants.USER_OPERATION_TTL, ChronoUnit.SECONDS));
        return params;
    }

    protected Map<String, Object> buildDeleteParams(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        HashMap params = Maps.newHashMap();
        params.put("userId", authoredUser.getUserId());
        params.put("tenantId", authoredUser.getTenantId());
        params.put("pageType", pageModelBodyDTO.getType());
        params.put("pageCode", pageModelBodyDTO.getActivityCode());
        params.put("updateTime", LocalDateTime.now().minus(Constants.USER_OPERATION_TTL, ChronoUnit.SECONDS));
        params.put("clientId", pageModelBodyDTO.getClientId());
        if (!CollectionUtils.isEmpty(pageModelBodyDTO.getBusinessKeys())) {
            params.put("businessKeys", pageModelBodyDTO.getBusinessKeys());
        }
        return params;
    }

    protected Map<String, Object> buildQueryTakeUpForReleaseAllParams(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        HashMap params = Maps.newHashMap();
        params.put("userId", authoredUser.getUserId());
        params.put("tenantId", authoredUser.getTenantId());
        params.put("pageType", pageModelBodyDTO.getType());
        params.put("pageCode", pageModelBodyDTO.getActivityCode());
        params.put("updateTime", LocalDateTime.now().minus(Constants.USER_OPERATION_TTL, ChronoUnit.SECONDS));
        params.put("clientId", pageModelBodyDTO.getClientId());
        params.put("takeUp", "1");
        return params;
    }

    @Override
    protected Map<String, Object> buildCheckNoTakeUpParams(UserOperationRecordDTO authoredUser) {
        HashMap params = Maps.newHashMap();
        params.put("client_id", authoredUser.getClientId());
        params.put("take_up", "0");
        return params;
    }

    @Override
    public String getLockKey(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        StringBuilder lockBuilder = new StringBuilder();
        lockBuilder.append("audc:");
        lockBuilder.append(authoredUser.getTenantId());
        lockBuilder.append(":");
        lockBuilder.append(pageModelBodyDTO.getType());
        lockBuilder.append(":");
        lockBuilder.append(pageModelBodyDTO.getActivityCode());
        lockBuilder.append(":");
        return lockBuilder.toString();
    }

    @Override
    public String getLockKey(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO, String businessKey) {
        StringBuilder lockBuilder = new StringBuilder();
        lockBuilder.append("audc:");
        lockBuilder.append(authoredUser.getTenantId());
        lockBuilder.append(":");
        lockBuilder.append(pageModelBodyDTO.getType());
        lockBuilder.append(":");
        lockBuilder.append(pageModelBodyDTO.getActivityCode());
        lockBuilder.append(":");
        lockBuilder.append(businessKey);
        return lockBuilder.toString();
    }
}

