/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class ZipUtils {
    public static byte[] extracted(InputStream sourceFileInputStream, String password, String zipName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setFileNameInZip(zipName);
        zipParameters.setEncryptFiles(true);
        zipParameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)baos, password.toCharArray());){
            int len;
            zipOutputStream.putNextEntry(zipParameters);
            byte[] buffer = new byte[1024];
            while ((len = sourceFileInputStream.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, len);
            }
            zipOutputStream.closeEntry();
        }
        return baos.toByteArray();
    }
}

