package com.digiwin.athena.base.application.meta.dto.commonused;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * 交付设计器的待办工作台设置中的条件
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WSConditionVO {

    private String appCode;

    private String taskCode;

    private String taskName;

    /**
     * 名称
     */
    private String aliasName;
    /**
     * 代号
     */
    private String aliasCode;

    /**
     * 交付设计器，常规分组条件是否选中
     */
    private Boolean commonEnable;

    /**
     * 交付设计器界面拖拽排序
     */
    private Integer sort;
    /**
     * 类型
     */
    private String dataType;

    private SourceType sourceType;

    private List<PointInTime> pointInTime;

    private List<Dimensionality> dimensionality;
    /**
     * 常规分组条件启用
     */
    private Boolean defaultEffective;

    /**
     * 是否启用
     */
    private Boolean enable;

    /**
     * 分组下，是否默认分组项
     */
    private Boolean defaultGroup;

    public Map<String, Map<String, String>> lang;
}
