package com.digiwin.athena.base.application.meta.dto.userdefined;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 融合组件用户自定义配置
 *
 * @author xuhx
 * @date 2025/8/6
 */
@Getter
@Setter
@ToString(callSuper = true)
@NoArgsConstructor
public class FusionComponentUserDefinedDTO {

    private String tenantId;

    private String userId;

    private String pageCode;

    private String businessId;

    private Object context;

    private LocalDateTime createDate;

    private LocalDateTime updateDate;

    public void checkParam() {
        if (StringUtils.isEmpty(pageCode)) {
            throw new RuntimeException("pageCode is empty");
        }
        if (StringUtils.isEmpty(businessId)) {
            throw new RuntimeException("businessId is empty");
        }
    }
}
