package com.digiwin.athena.base.application.meta.request.attachment;

import com.digiwin.athena.base.sdk.aam.application.meta.validator.ValidateGroup;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @program: aam
 * @description: 查询上传数量参数
 * @author: Hang Liu
 * @create: 2023-04-14 10:50
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AttachUploadedCountDTO {



    /**
     * table行数据唯一标示key
     */
    @NotEmpty(groups = ValidateGroup.Save.class)
    private String rowDataKey;


    /**
     * 附件目录列表
     */
    @NotEmpty(groups = ValidateGroup.Save.class)
    private List<String> categoryList;

    /**
     * 租户id
     */
    @NotEmpty(groups = ValidateGroup.Save.class)
    private String tenantId;

    /**
     * 活动id
     */
    private String taskId;

    /**
     * 项目id
     */
    private String projectId;

}
