package com.digiwin.athena.base.application.meta.request.attachment;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 分享文档的入参
 *  "fileId":"mock",                //类型：String  必有字段  备注：文件ID
 *     "dirId":"mock",                //类型：String  可有字段  备注：目录ID
 *     "fileIds": - [                //类型：Array  可有字段  备注：文件ID集合
 *     ],
 *     "dirIds": - [                //类型：Array  可有字段  备注：目录ID集合
 *     ],
 *     "expireDate":"mock"
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ShareAttachmentDTO {

    /**
     * 文件id
     */
    private String fileId;

    private String dirId;

    /**
     * 批量文件id
     */
    private List<String> fileIds;

    private List<String> dirIds;

    /**
     * 过期时间
     */
    private String expireDate;

    /**
     * 登录token
     */
    private String token;
}
