package com.digiwin.athena.base.application.meta.request.usertrack;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UserTrackSearchDTO {

    /**
     * 作业类型，如：任务 task， 项目：Project，报表：report，基础资料录入：base-data
     */
    private String workType;
    /**
     * 作业ThemeMap定义的code，如：基础资料录入-客户建立：baseDataEntry_clients
     */
    private String workCode;
    /**
     * 执行的操作，如：打开查看：OPEN，提交：SUBMIT
     */
    private List<String> operations;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 创建时间（最小）
     */
    private String startTime;
    /**
     * 创建时间（最大）
     */
    private String endTime;
}
