package com.digiwin.athena.base.application.meta.response.audc;

import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.ThePrincipalTaskType;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 查询被代理人可被代理的任务类型 返回参数
 *
 * @author chenpeng
 * @date 2024年8月26日
 * @since
 */
@Data
public class TaskTypeQueryResp {

    /**
     * 被代理人id
     */
    private String thePrincipalId;
    /**
     * 代理人id
     */
    private String agentId;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 任务类型
     */
    private String taskDefCode;
    /**
     * 创建时间
     */
    private LocalDateTime createDate;
    /**
     * 修改时间
     */
    private LocalDateTime modifyDate;
    /**
     * 是否为行事历任务
     */
    private boolean calendarTask;

    public TaskTypeQueryResp(ThePrincipalTaskType thePrincipalTaskType) {
        this.thePrincipalId = thePrincipalTaskType.getThePrincipalId();
        this.tenantId = thePrincipalTaskType.getTenantId();
        this.taskDefCode = thePrincipalTaskType.getTaskDefCode();
        this.agentId = thePrincipalTaskType.getAgentId();
        this.createDate = thePrincipalTaskType.getCreateDate();
        this.modifyDate = thePrincipalTaskType.getModifyDate();
        this.calendarTask = Objects.equals(thePrincipalTaskType.getCalendarTask(), 1) ? true : false;
    }
}
