package com.digiwin.athena.base.application.schedule;

import com.digiwin.athena.base.application.service.userdefined.UserPageModelBaseDataService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @description:定时任务：每天凌晨3点删除过期的用户操作
 * @author: lisheng
 * @date: 2023/10/19 09:33
 */
@Component
@Slf4j
public class ClearExpireUserOperationSchedule {

    // 定时任务，每隔半小时执行一次
    private static final String CLEAR_EXPIRE_USER_OPERATION_CORN = "0 0/5 * * * ?";

    @Autowired
    private UserPageModelBaseDataService userPageModelBaseDataService;

    /**
     * 定时任务：每天凌晨3点删除过期的用户操作
     */
    @Scheduled(cron = CLEAR_EXPIRE_USER_OPERATION_CORN)
    public void clearExpireUserOperation() {
        log.info("clearExpireUserOperation start");
        int result = userPageModelBaseDataService.deleteExpire();
        log.info("clearExpireUserOperation end,result:{}",result);
    }
}
