package com.digiwin.athena.base.application.service.attachment;


import com.digiwin.athena.base.application.meta.request.attachment.AttachUploadedCountDTO;
import com.digiwin.athena.base.application.meta.request.attachment.AttachmentDownloadReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.UploadParamDTO;
import com.digiwin.athena.base.application.meta.response.attachment.UploadAttachmentRespDTO;
import com.digiwin.athena.base.application.meta.request.attachment.AttachmentReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.DeleteAttachmentReqDTO;
import com.digiwin.athena.base.sdk.aam.application.meta.request.QueryAttachmentReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.UploadOrDeleteAttachmentReqDTO;
import com.digiwin.athena.base.sdk.aam.application.meta.response.AttachmentRespDTO;

import java.util.List;
import java.util.Map;

public interface AttachmentService {
    /**
     * 根据活动id、租户id和行数据标识列表查询
     *
     * @param tenantId       租户id
     * @param taskId         tmActivityId
     * @param projectId      项目id
     * @param categories     附件目录列表
     * @param rowDataKeyList 行数据标识列表
     * @return 附件信息
     */
    List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList);

    /**
     * 根据活动id、租户id和行数据标识列表查询
     *
     * @param queryAttachmentReqDTO
     */
    List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(QueryAttachmentReqDTO queryAttachmentReqDTO);

    /**
     * 保存附件信息
     *
     * @param attachmentFile 上传的附件信息
     */
    void saveAttachment(AttachmentReqDTO attachmentFile);

    /**
     * 根据id、category（可为空）、categoryId（可为空）删除附件信息
     *
     * @param attachmentFile 要删除的附件信息
     */
    void deleteAttachment(AttachmentReqDTO attachmentFile);

    /**
     * 上传保存or删除附件信息
     *
     * @param uploadOrDeleteAttachmentReqDTO
     * @return
     */
    void uploadOrDeleteAttachment(UploadOrDeleteAttachmentReqDTO uploadOrDeleteAttachmentReqDTO);

    /**
     * 删除附件信息
     *
     * @param deleteAttachmentReqDTO
     * @return
     */
    void deleteAttachmentBatch(DeleteAttachmentReqDTO deleteAttachmentReqDTO);

    String uploadAttachmentByUrl(UploadParamDTO uploadParamDTO);

    /**
     * 上传文档
     *
     * @param uploadParamDTO
     * @return
     */
    UploadAttachmentRespDTO uploadAgileReport(UploadParamDTO uploadParamDTO);

    /**
     * 根据条件查询已经上传的附件数量
     *
     * @param attachUploadedCountDTO
     * @return
     */
    Long attachUploadedCount(AttachUploadedCountDTO attachUploadedCountDTO);

    /**
     * 校验当前上传的数量是否超过允许的数量
     *
     * @param attachmentFile
     * @return
     */
    boolean checkUploadCount(AttachmentReqDTO attachmentFile);

    /**
     * 获取报表文档信息
     *
     * @param fileId
     * @return
     */
    Map<String, Object> getFile(String fileId);

    /**
     * 删除文档
     *
     * @param fileId
     * @return
     */
    Map<String, Object> deleteFile(String fileId);


    /**
     * 加密、水印下载附件
     *
     * @param attachmentDownloadReqDTO
     */
    Object download(AttachmentDownloadReqDTO attachmentDownloadReqDTO);

    /**
     * 水印下载图片附件
     *
     * @param attachmentDownloadReqDTOList
     * @return
     */
    Object downloadImageWatermarkBase64(List<AttachmentDownloadReqDTO> attachmentDownloadReqDTOList);

    /**
     * 批量下载附件
     * 本期不考虑水印和密码加密
     *
     * @param attachmentBatchDownloadReqDTO
     * @return
     */
    Object batchDownload(AttachmentDownloadReqDTO attachmentBatchDownloadReqDTO);

}
