package com.digiwin.athena.base.application.service.commonused;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.dto.commonused.TmDataListDTO;
import com.digiwin.athena.base.application.meta.request.commonused.BatchSortItemReq;
import com.digiwin.athena.base.application.meta.response.commonused.CateAndItemResp;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseItemDto;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.CategoryData;
import com.digiwin.athena.datamap.sdk.meta.dto.response.TmStartProjectDTO;

import java.util.List;
import java.util.Map;

public interface CommonUsedService {

    /**
     * 查询对应的模块常用下分类以及分类子项信息
     *
     * @param user   用户信息
     * @param plat   所属模块0:基础资料录入 1：报表，后续有新增则依次递增
     * @param cateId 分类ID -1：根节点
     */
    CateAndItemResp cateAndItemList(AuthoredUser user, Integer plat, Long cateId);


    /**
     * 删除指定的分类
     *
     * @param user 用户信息
     * @param id   分类id
     * @return 操作结果
     */
    int deleteCommUsedCate(AuthoredUser user, Long id, Integer plat);

    /**
     * 删除指定的分类，并将对应的子项移动的到默认分组中
     *
     * @param user 用户信息
     * @param id   分类id
     * @return 操作结果
     */
    int deleteCateAndMoveItems(AuthoredUser user, Long id, Integer plat);

    /**
     * 根据当前登录的用户语言，去寻找基础资料录入的详情
     *
     * @param user 用户信息
     * @param plat 0:基础资料录入 1：报表
     * @return 返回信息
     */
    Map<String, String> queryEntryData(AuthoredUser user, Integer plat);

    /**
     * 获取全部基础资料录入/报表数据
     * @param user 用户信息
     * @param plat 0:基础资料 1：报表
     * @param allowRepeat  true：允许（默认） false：不允许
     * @param pattern  模式：MOBI-STATEMENT（移动报表），不传默认STATEMENT
     * @param effect 选填，只查询访问权限为effect值的作业列表
     */
    List<TmDataListDTO> tmDataList(AuthoredUser user, Integer plat, boolean allowRepeat, Boolean searchData, List<BaseItemDto> baseDataEntryJobList, String pattern, String effect);

    /**
     * 获取常用分组
     *
     * @Author：SYQ
     * @Date：2021/10/13 17:08
     */
    List<CategoryData> finCategory(AuthoredUser user, Integer plat, Long cateId);

    /**
     * 获取发起项目列表
     * @param user
     * @return
     */
    List<TmStartProjectDTO> startProjectList(AuthoredUser user, Boolean hasStartProject, List<TmStartProjectDTO> startProjectJobList);


    Boolean saveCustomSort(AuthoredUser user, BatchSortItemReq items);
}
