package com.digiwin.athena.base.application.service.proxyinfo;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoRemoveReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoSaveReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.SaveSubordinateReq;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocEmpInfoDTO;

import java.util.List;

/**
 * ProxyInfoService Description
 *
 * @author chenpeng
 * @date 2024年8月29日
 * @since
 */
public interface ProxyInfoService {

    /**
     * 保存代理人信息
     *
     * @param proxyInfoSaveReq
     * @param user
     */
    void saveProxyInfo(ProxyInfoSaveReq proxyInfoSaveReq, AuthoredUser user);

    /**
     * 清除代理人信息
     *
     * @param proxyInfoRemoveReq
     * @param user
     */
    void removeProxyInfo(ProxyInfoRemoveReq proxyInfoRemoveReq, AuthoredUser user);

    /**
     * 查询下属代理人列表
     *
     * @param user
     * @return
     */
    List<EocEmpInfoDTO> querySubordinate(AuthoredUser user);

    /**
     * 保存下属代理人信息
     * @param saveSubordinateReq
     * @param user
     */
    void saveSubordinate(SaveSubordinateReq saveSubordinateReq, AuthoredUser user);

    /**
     * 删除下属代理人信息
     * @param proxyInfoRemoveReq
     * @param user
     */
    void removeSubordinate(ProxyInfoRemoveReq proxyInfoRemoveReq, AuthoredUser user);
}
