package com.digiwin.athena.base.application.service.trial;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.config.BaseAudcDataSourceConfig;
import com.digiwin.athena.base.application.meta.request.trial.step.TrialStepReq;
import com.digiwin.athena.base.application.meta.request.trial.step.TrialStepResp;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialStepMapper;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialStepData;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 描述
 * 试用步骤的业务处理类
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/03 15:44:41
 */
@Service
public class TrialStepServiceImpl implements TrialStepService {

    private final TrialStepMapper trialStepMapper;

    @Autowired
    public TrialStepServiceImpl(TrialStepMapper trialStepMapper) {
        this.trialStepMapper = trialStepMapper;
    }

    /**
     * 新增试用步骤
     *
     * @param stepReq stepReq
     * @return int
     */
    @Override
    @Transactional(transactionManager = BaseAudcDataSourceConfig.BASE_AUDC_DATASOURCE_TRANSACTION_MANAGER_BUSINESS)
    public Long add(TrialStepReq stepReq) {
        TrialStepData stepData = new TrialStepData();
        BeanUtils.copyProperties(stepReq, stepData);
        stepData.setId(SnowflakeIdWorker.getInstance().newId());
        stepData.setCreateDate(LocalDateTime.now());
        stepData.setModifyDate(LocalDateTime.now());
        int result = trialStepMapper.insert(stepData);
        return stepData.getId();
    }


    /**
     * 修改试用步骤
     *
     * @param stepReq stepReq
     * @return int
     */
    @Override
    @Transactional(transactionManager = BaseAudcDataSourceConfig.BASE_AUDC_DATASOURCE_TRANSACTION_MANAGER_BUSINESS)
    public int modify(TrialStepReq stepReq) {
        TrialStepData stepData = new TrialStepData();
        stepData.setModifyDate(LocalDateTime.now());
        stepData.setId(stepReq.getId());
        stepData.setStepDesc(stepReq.getStepDesc());
        stepData.setStepDetail(stepReq.getStepDetail());
        return trialStepMapper.updateById(stepData);
    }

    /**
     * 查询试用步骤列表
     *
     * @return list
     */
    @Override
    public List<TrialStepData> list(TrialStepReq stepReq) {
        QueryWrapper<TrialStepData> wrapper = new QueryWrapper<>();
        //如果有没有输入条件，查询所有
        if (StringUtils.isNotEmpty(stepReq.getStepKey())) {
            wrapper.likeRight("step_key", stepReq.getStepKey());
        }
        return trialStepMapper.selectList(wrapper);
    }

    /**
     * 查询试用步骤列表
     *
     * @return list
     */
    @Override
    public TrialStepResp detail(String stepKey) {
        QueryWrapper<TrialStepData> wrapper = new QueryWrapper<>();
        wrapper.eq("step_key", stepKey);
        TrialStepData stepData = trialStepMapper.selectOne(wrapper);
        TrialStepResp resp = new TrialStepResp();
        BeanUtils.copyProperties(stepData, resp);
        return resp;
    }


    /**
     * 根据id删除试用步骤
     *
     * @param id id
     * @return int
     */
    @Override
    @Transactional(transactionManager = BaseAudcDataSourceConfig.BASE_AUDC_DATASOURCE_TRANSACTION_MANAGER_BUSINESS)
    public int deleteById(Long id) {
        return trialStepMapper.deleteById(id);
    }
}
