/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.importstatistics.service.impl;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.configuration.DMCConfig;
import com.digiwin.athena.atdm.importstatistics.dto.ExportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.entity.DMCTokenBean;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelTypeEnum;
import com.digiwin.athena.base.application.service.importstatistics.service.DataEntryDmcService;
import com.digiwin.athena.base.application.service.importstatistics.service.DataEntryErrorHandlerService;
import com.digiwin.athena.base.application.service.importstatistics.service.helpler.ExcelHelper;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DataEntryExportStatisticsDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEntryExportStatisticsDomainService.class);
    @Autowired
    ExcelHelper excelHelper;
    @Autowired
    @Qualifier(value="rabbitDataEntryErrorHandlerServiceImpl")
    DataEntryErrorHandlerService errorHandlerService;
    @Autowired
    DMCConfig dmcConfig;
    @Autowired
    DMCTokenBean dmcTokenBean;
    @Autowired
    DataEntryDmcService dmcService;
    private static final String EXCEL_SUFFIX = ".xlsx";

    public void downloadExportFile(ExportStatisticsDTO exportStatisticsDTO, HttpServletResponse response) {
        String fileUrl = exportStatisticsDTO.getFileUrl();
        if (StringUtils.isEmpty((String)fileUrl)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0066.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.notFoundExportExcel", (Object[])new Object[0]));
        }
        response.setContentType(ExcelTypeEnum.XLSX.value());
        response.setCharacterEncoding("utf-8");
        String formFileName = exportStatisticsDTO.getFileName() + EXCEL_SUFFIX;
        try (InputStream inputStream = this.dmcService.getExportFileInputStream(fileUrl);
             ServletOutputStream os = response.getOutputStream();){
            formFileName = URLEncoder.encode(formFileName, "UTF-8");
            formFileName = formFileName.replaceAll("\\+", "%20");
            response.addHeader("Content-Disposition", "attachment;filename=" + formFileName);
            response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
            IOUtils.copy((InputStream)inputStream, (OutputStream)os);
        }
        catch (IOException e) {
            log.error("\u5bfc\u51fa\u5f02\u5e38\u6570\u636e\u5199\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }
}

