/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.userdefined;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.application.meta.request.userdefined.AgileReportUserDefineDTO;
import com.digiwin.athena.base.application.service.userdefined.AgileReportUserDefineService;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.meta.po.userdefined.mongo.UserDefineData;
import com.digiwin.athena.base.infrastructure.mongo.AgileReportUserDefineMongoMapper;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AgileReportUserDefineServiceImpl
implements AgileReportUserDefineService {
    private Logger logger = LoggerFactory.getLogger(AgileReportUserDefineServiceImpl.class);
    @Autowired
    AgileReportUserDefineMongoMapper agileReportUserDefineMongoMapper;
    @Resource
    private MessageUtils messageUtils;

    @Override
    public void save(String userId, String tenantId, AgileReportUserDefineDTO userDefineDTO) {
        this.logger.info("[UserDefineServiceImpl.save],userId is" + userId + "tenantId is" + tenantId + "userDefineDTO is" + userDefineDTO);
        if (!ObjectUtils.isEmpty((Object)userDefineDTO)) {
            UserDefineData userDefineData = new UserDefineData();
            if (StringUtils.isEmpty((Object)userId) || StringUtils.isEmpty((Object)tenantId) || StringUtils.isEmpty((Object)userDefineDTO.getSnapshotId()) || userDefineDTO.getDashboard().isEmpty()) {
                throw AudcErrorCodeEnum.EMPTY_STRING_ERROR.getBusinessException(this.messageUtils.getMessage("exception.empty.strings.error"));
            }
            userDefineData.setUserId(userId);
            userDefineData.setTenantId(tenantId);
            userDefineData.setSnapshotId(userDefineDTO.getSnapshotId());
            userDefineData.setDashboard(userDefineDTO.getDashboard());
            this.agileReportUserDefineMongoMapper.save(userDefineData);
        }
    }

    @Override
    public List<UserDefineData> getUserDefine(String snapshotId, String userId, String tenantId) {
        return this.agileReportUserDefineMongoMapper.getUserDefine(snapshotId, userId, tenantId);
    }
}

