package com.digiwin.athena.base.application.eventbus.subscriber;

import com.digiwin.athena.base.application.eventbus.event.MessageAgentChangeBatchEvent;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentChangeEvent;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentClearBatchEvent;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentClearEvent;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoSaveReq;
import com.digiwin.athena.base.infrastructure.manager.atmc.BaseAtmcService;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.NoticeProxyInfoDTO;
import com.digiwin.athena.base.infrastructure.manager.eoc.BaseEocService;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author：chenpeng
 */
@Component
@Slf4j
public class MessageAgentChangeSubscriber {
    @Resource
    private BaseAtmcService baseAtmcService;
    @Resource
    private BaseEocService eocService;

    /**
     * 代理信息修改事件处理
     *
     * @param event
     */
    @Subscribe
    public void messageAgentChange(MessageAgentChangeEvent event) {
        Map<String, Object> param = new HashMap<>();
        param.put("userId", event.getUserId());
        param.put("agentId", event.getAgentId());
        param.put("agentBeginDate", event.getAgentBeginDate());
        param.put("agentEndDate", event.getAgentEndDate());
        baseAtmcService.messageAgentChange(param, event.getToken());
    }

    /**
     * 代理信息清除事件处理
     *
     * @param event
     */
    @Subscribe
    public void messageAgentClear(MessageAgentClearEvent event) {
        baseAtmcService.messageAgentClear(event.getUserId(), event.getToken());
    }

    /**
     * 批量发送消息提醒事件
     *
     * @param event
     */
    @Subscribe
    public void messageAgentBatchChange(MessageAgentChangeBatchEvent event) {
        List<NoticeProxyInfoDTO> list = new ArrayList<>();
        for (ProxyInfoSaveReq proxyInfoSaveReq : event.getList()) {
            NoticeProxyInfoDTO dto = new NoticeProxyInfoDTO();
            dto.setAgentId(proxyInfoSaveReq.getAgentId());
            dto.setAgentName(proxyInfoSaveReq.getAgentName());
            dto.setPrincipalId(proxyInfoSaveReq.getUserId());
            dto.setPrincipalName(proxyInfoSaveReq.getUserName());
            dto.setStartDate(proxyInfoSaveReq.getAgentBeginDate());
            dto.setEndDate(proxyInfoSaveReq.getAgentEndDate());
            list.add(dto);
        }
        baseAtmcService.messageAgentBatchChange(list, event.getToken());
    }

    /**
     * 批量清除代理人信息事件
     *
     * @param event
     */
    @Subscribe
    public void messageAgentClearBatchEvent(MessageAgentClearBatchEvent event) {
        if (CollectionUtils.isNotEmpty(event.getUserList())) {
            event.getUserList().forEach(userId -> {
                eocService.empAgentClear(userId, event.getUser());
                baseAtmcService.messageAgentClear(userId, event.getUser().getToken());
            });
        }
    }

}
