package com.digiwin.athena.base.application.service.calendar;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseActivityDefineDTO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * CalendarServiceImpl Description
 *
 * @author majianfu
 * @date 2022/8/17
 * @since
 */
@Service
public class CalendarServiceImpl implements CalendarService {
    private static final String PATTERN = "CALENDAR";

    @Autowired
    private BaseThemeMapService baseThemeMapService;
    @Resource
    private MessageUtils messageUtils;

    /**
     * {@inheritDoc}
     */
    @Override
    public List<BaseActivityDefineDTO> queryCalendarTaskList(AuthoredUser authoredUser, List<String> excludeCategories) {
        List<BaseActivityDefineDTO> taskList = baseThemeMapService.getTenantActivitiesByPattern(PATTERN);
        if (CollectionUtils.isNotEmpty(taskList) && CollectionUtils.isNotEmpty(excludeCategories)) {
            return taskList.stream()
                    .filter(task -> !excludeCategories.contains(task.getCategory()))
                    .collect(Collectors.toList());
        }
        return taskList;
    }

    /**
     * 获取用户拥有的行事历任务类型
     *
     * @return
     */
    @Override
    public List<BaseActivityDefineDTO> queryCalendarTaskList() {
        // 调用km查询任务列表
        List<BaseActivityDefineDTO> taskList = baseThemeMapService.getTenantActivitiesByPattern(PATTERN);
        if (CollectionUtils.isEmpty(taskList)) {
            taskList = new ArrayList<>(1);
        }
        //taskList中加上一行 平台行事历数据。
        BaseActivityDefineDTO baseActivityDefineDTO = new BaseActivityDefineDTO();
        baseActivityDefineDTO.setAppCode("athena");
        // "雅典娜",  需要多语言处理
        baseActivityDefineDTO.setAppName(messageUtils.getMessage("calendar.app.name"));
        baseActivityDefineDTO.setPattern(PATTERN);
        baseActivityDefineDTO.setCategory("PROCESS");
        baseActivityDefineDTO.setCode("platformManualTask");
        // "name": "平台行事历" 需要多语言处理
        baseActivityDefineDTO.setName(messageUtils.getMessage("calendar.name"));
        taskList.add(baseActivityDefineDTO);
        return taskList;
    }
}
