package com.digiwin.athena.base.application.service.importstatistics.service.impl;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.configuration.DMCConfig;
import com.digiwin.athena.atdm.importstatistics.entity.DMCTokenBean;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelTypeEnum;
import com.digiwin.athena.base.application.service.importstatistics.service.DataEntryDmcService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName DmcServiceImpl
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/27 10:02
 * @Version 1.0
 **/
@Service
public class DataEntryDmcServiceImpl implements DataEntryDmcService {

    @Resource
    RestTemplate dmcRestTemplate;

    @Autowired
    DMCConfig dmcConfig;
    @Autowired
    DMCTokenBean dmcTokenBean;

    @Value("${dmc.uri}")
    private String dmcUrl;

    @Override
    public void refreshToken() {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.set("digi-middleware-auth-app", GlobalConstant.IAM_APP_TOKEN_ATHENA);
        Map<String, String> reqMap = new HashMap<>();
        reqMap.put("username", dmcConfig.getUserName());
        reqMap.put("pwdhash", dmcConfig.getPassword());

        String url = dmcUrl + "/api/dmc/v1/auth/login";

        HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity(reqMap, header);
        ResponseEntity<Map> resMap = dmcRestTemplate.postForEntity(url, httpEntity, Map.class);
        String token = (String) resMap.getBody().get("userToken");
        if (StringUtils.isEmpty(token)) {
            throw BusinessException.create(ErrorCodeEnum.DMC_V2_LOGIN.getErrCode(),"获取token失败");
        }
        dmcTokenBean.setToken(token);
    }

    /**
     * 获取导出文件流
     * @param fileUrl
     * @return
     */
    public InputStream getExportFileInputStream(String fileUrl) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", dmcTokenBean.getToken());
        headers.add("digi-middleware-auth-app", GlobalConstant.IAM_APP_TOKEN_ATHENA);
        List list = new ArrayList<>();
        list.add(MediaType.parseMediaType(ExcelTypeEnum.XLSX.value()));
        headers.setAccept(list);
        String url = dmcUrl + "/api/dmc/v2/file/" + dmcConfig.getBucket()+ "/download/" + fileUrl;
        ResponseEntity<byte[]> restRes = dmcRestTemplate.exchange(
                url,
                HttpMethod.GET,
                new HttpEntity<byte[]>(headers),
                byte[].class);
        return new ByteArrayInputStream(restRes.getBody());
    }
}
