package com.digiwin.athena.base.application.service.userdefined;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.application.converter.DataConverter;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserDefinedCenterDTO;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserDefinedCenterMetadataResult;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserGridDTO;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.ThemeMapTag;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.ThemeMapTagResponse;
import com.digiwin.athena.base.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsResponse;
import com.digiwin.athena.base.application.meta.dto.userdefined.SearchConditionGroup;
import com.digiwin.athena.base.infrastructure.mongo.UserDefinedMongoMapper;
import com.digiwin.athena.base.sdk.audc.application.service.userdefined.QueryUserDefinedService;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsBO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserGridPO;
import com.google.common.collect.Maps;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xuxx
 * @date 2022/1/5
 * @since
 */
@Service
public class UserDefinedServiceImpl implements UserDefinedService {
    private Logger logger = LoggerFactory.getLogger(UserDefinedServiceImpl.class);

    //字段排序
    private String PURPOSE_FIELDSEQBYUSER = "FieldSeqByUser";

    //数据排序条件
    private String PURPOSE_ORDERCONDITIONS = "OrderConditions";

    @Autowired
    private UserDefinedMongoMapper userDefinedMongoMapper;

    @Autowired
    private QueryUserDefinedService queryUserDefinedService;

    @Resource
    private MessageUtils messageUtils;

    /**
     * 栏位保存
     *
     * @param fieldJson
     */
    public void save(AuthoredUser user, JSONObject fieldJson) {
        logger.info("[UserDefinedServiceImpl.save],user is" + user + "fieldJson is" + fieldJson);
        try {
            if (fieldJson != null) {
                UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
                if (fieldJson.get("pageCode") != null) {
                    userDefined.setPageCode(fieldJson.getString("pageCode"));
                }
                if (fieldJson.get("tmDefinition") != null) {
                    JSONObject tmDefinition = fieldJson.getJSONObject("tmDefinition");
                    if (tmDefinition != null) {
                        if (tmDefinition.get("tmActivityId") != null) {
                            userDefined.setTmActivityId(tmDefinition.getString("tmActivityId"));
                        }
                        if (tmDefinition.get("tmProjectId") != null) {
                            userDefined.setTmProjectId(tmDefinition.getString("tmProjectId"));
                        } else {
                            userDefined.setTmProjectId("__uibot__");
                        }
                    }
                    if (fieldJson.get("fields") != null) {
                        List<Map<String, Object>> fieldsList = fieldJson.getJSONArray("fields");
                        int index = 1;
                        if ("project-detail".equals(userDefined.getPageCode())) {
                            index = 3;
                        }
                        List<UserDefinedCenterMetadataResult> metadataTags = new ArrayList<>();
                        for (Map<String, Object> field : fieldsList) {
                            UserDefinedCenterMetadataResult metadataTagResult = new UserDefinedCenterMetadataResult();
                            if (field.get("name") != null) {
                                ThemeMapTag temp_tag = new ThemeMapTag();
                                if ("activity__performerName".equals(field.get("name").toString())) {
                                    continue;
                                }
                                String orderCode = "ORDER_" + index;
                                temp_tag.setCode(orderCode);
                                temp_tag.setValue(String.valueOf(index));
                                temp_tag.setCategory("ORDER");
                                temp_tag.setName("xxxx");
                                temp_tag.setUiBotCode("ORDER");

                                List<ThemeMapTag> tags = new ArrayList<>();
                                tags.add(temp_tag);
                                metadataTagResult.setTags(tags);
                                ThemeMapTagResponse resourceContent = new ThemeMapTagResponse();
                                resourceContent.setResponse(field.get("name").toString());
                                metadataTagResult.setResourceContent(resourceContent);

                                String newField = field.get("name").toString();
                                if (field.get("name").toString().contains(".")) {
                                    String fieldNames[] = field.get("name").toString().split("\\.");
                                    newField = fieldNames[fieldNames.length - 1];
                                    if (StringUtils.isEmpty(userDefined.getTableSchema())) {
                                        userDefined.setTableSchema(fieldNames[fieldNames.length - 2]);
                                    }
                                }
                                //预留GROUP、内含外显 等复合字段的位置
                                if (field.get("name").toString().endsWith("_no") || field.get("name").toString().endsWith("_name") || field.get("name").toString().endsWith("_No") || field.get("name").toString().endsWith("_Name") || newField.startsWith("new_") || newField.startsWith("old_")) {
                                    index = index + 4;
                                } else {
                                    index++;
                                }
                                //扩展属性
                                Map extendedArr = new HashMap();
                                //是否隐藏
                                if (field.get("hide") != null) {
                                    extendedArr.put("hide", Boolean.valueOf(field.get("hide").toString()));
                                }
                                //是否固定
                                if (field.get("pinned") != null) {
                                    extendedArr.put("pinned", field.get("pinned").toString());
                                }
                                //字段宽度
                                if (field.get("width") != null) {
                                    extendedArr.put("width", field.get("width").toString());
                                }
                                if (MapUtils.isNotEmpty(extendedArr)) {
                                    metadataTagResult.setExtendedAttributes(extendedArr);
                                }
                                metadataTags.add(metadataTagResult);
                            }
                        }
                        userDefined.setMetadataTags(metadataTags);
                    }
                }
                userDefined.setUserId(user.getUserId());
                userDefined.setTenantId(user.getTenantId());
                if (fieldJson.has("pageUniqueCode")) {
                    userDefined.setPageUniqueCode(fieldJson.getString("pageUniqueCode"));
                }
                userDefinedMongoMapper.save(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /**
     * 根据当前用户信息，获取tag列表
     *
     * @param user
     * @return
     */
    public UserDefinedCenterDTO getFieldSeqList(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        return getFieldSeqList(user, pageCode, tmProjectId, tmActivityId, tableSchema, null);
    }

    public UserDefinedCenterDTO getFieldSeqList(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode) {
        UserDefinedPO userDefinedPO = queryUserDefinedService.getFieldSeqList(user, pageCode, tmProjectId, tmActivityId, tableSchema, pageUniqueCode);
        return DataConverter.INSTANCE.toUserDefinedCenterDTO(userDefinedPO);
    }

    @Override
    public List<UserDefinedFieldsResponse> getFieldSeqList(List<String> tmActivityIdList) {
        List<UserDefinedFieldsBO> fieldSeqList = queryUserDefinedService.getFieldSeqList(tmActivityIdList);
        if (CollectionUtils.isNotEmpty(fieldSeqList)) {
            return fieldSeqList.stream().map(DataConverter.INSTANCE::toUserDefinedFieldsResponse).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    public void remove(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        if (StringUtils.isNotEmpty(tableSchema) && tableSchema.contains(".")) {
            tableSchema = tableSchema.split("\\.")[tableSchema.split("\\.").length - 1];
        }
        userDefined.setTableSchema(tableSchema);
        if ("undefined".equals(tmProjectId)) {
            tmProjectId = "__uibot__";
        }
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(PURPOSE_FIELDSEQBYUSER);
        userDefinedMongoMapper.remove(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
    }


    /**
     * 根据当前用户信息，保存数据排序条件
     *
     * @param fieldJson
     */
    public void saveOrderConditions(AuthoredUser user, JSONObject fieldJson) {

        try {
            if (fieldJson != null) {
                UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
                if (fieldJson.get("pageCode") != null) {
                    userDefined.setPageCode(fieldJson.getString("pageCode"));
                }
                if (fieldJson.get("tmDefinition") != null) {
                    JSONObject tmDefinition = fieldJson.getJSONObject("tmDefinition");
                    if (tmDefinition != null) {
                        if (tmDefinition.get("tmActivityId") != null) {
                            userDefined.setTmActivityId(tmDefinition.getString("tmActivityId"));
                        }
                        if (tmDefinition.get("tmProjectId") != null) {
                            userDefined.setTmProjectId(tmDefinition.getString("tmProjectId"));
                        } else {
                            userDefined.setTmProjectId("__uibot__");
                        }
                    }
                    // 存在自定义排序fields，且不为空
                    if (fieldJson.get("fields") != null && !fieldJson.getJSONArray("fields").isEmpty()) {
                        List<Map<String, Object>> fieldList = fieldJson.getJSONArray("fields");
                        Map<String, List> options = new HashMap<>();
                        options.put("options", fieldList);
                        Map<String, Object> order = new HashMap<>();
                        order.put("order", options);
                        JSONObject orderJson = JSONObject.fromObject(order);
                        userDefined.setSettings(orderJson);
                    }
                    if (fieldJson.containsKey("tableSchema") && fieldJson.get("tableSchema") != null) {
                        userDefined.setTableSchema(fieldJson.getString("tableSchema"));
                    }
                }
                userDefined.setUserId(user.getUserId());
                userDefined.setTenantId(user.getTenantId());
                if (fieldJson.has("pageUniqueCode")) {
                    userDefined.setPageUniqueCode(fieldJson.getString("pageUniqueCode"));
                }
                userDefinedMongoMapper.saveOrderConditions(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /**
     * 根据当前用户信息，获取数据排序条件
     *
     * @param user
     * @return
     */
    public UserDefinedCenterDTO getOrderConditionsByUser(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        return getOrderConditionsByUser(user, pageCode, tmProjectId, tmActivityId, tableSchema, null);
    }

    public UserDefinedCenterDTO getOrderConditionsByUser(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode) {
        UserDefinedPO userDefinedPO = queryUserDefinedService.getOrderConditionsByUser(user, pageCode, tmProjectId, tmActivityId, tableSchema, pageUniqueCode);
        return DataConverter.INSTANCE.toUserDefinedCenterDTO(userDefinedPO);
    }

    @Override
    public List<UserDefinedCenterDTO> getOrderConditionsFields(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        List<UserDefinedPO> userDefinedPOS = queryUserDefinedService.getOrderConditionsFields(user, pageCode, tmProjectId, tmActivityId, tableSchema);
        if (CollectionUtils.isNotEmpty(userDefinedPOS)) {
            return userDefinedPOS.stream().map(DataConverter.INSTANCE::toUserDefinedCenterDTO).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    public void removeOrderConditions(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        userDefined.setTableSchema(tableSchema);
        if ("undefined".equals(tmProjectId)) {
            tmProjectId = "__uibot__";
        }
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(PURPOSE_ORDERCONDITIONS);
        userDefinedMongoMapper.remove(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
    }

    @Override
    public UserDefinedCenterDTO getUserShrink(AuthoredUser user, String tmActivityId) {
        UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setTmActivityId(tmActivityId);
        UserDefinedPO userShrink = userDefinedMongoMapper.getUserShrink(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
        return DataConverter.INSTANCE.toUserDefinedCenterDTO(userShrink);
    }

    @Override
    public void saveUserShrink(AuthoredUser user, JSONObject fieldJson) {
        try {
            if (fieldJson != null) {
                UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
                if (fieldJson.getString("tmActivityId") != null) {
                    userDefined.setTmActivityId(fieldJson.getString("tmActivityId"));
                }
                if (fieldJson.get("settings") != null) {
                    List<Map<String, Object>> settings = fieldJson.getJSONArray("settings");
                    Map<String, Object> order = new HashMap<>();
                    order.put("shrink", settings);
                    JSONObject orderJson = JSONObject.fromObject(order);
                    userDefined.setSettings(orderJson);
                }
                userDefined.setUserId(user.getUserId());
                userDefined.setTenantId(user.getTenantId());
                userDefinedMongoMapper.saveUserShrink(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }


    /**
     * 表格独立使用，根据当前用户信息，获取字段及其属性
     *
     * @param user
     * @param pageCode:project-detail、task-detail
     * @param tmProjectId:当前任务所对应的项目定义code
     * @param tmActivityId:当前任务所对应的任务定义code
     * @param table:当前表格对应的schema
     * @return
     */
    public Object getFieldArrtList(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String table) {

        //返回给前端的结构
        Map<String, Map<String, Object>> fieldArrMap = new HashMap<>();
        //存放所有字段及属性
        List columns = new ArrayList();
        //存放某一个table的所有返回信息：columns、settings
        Map columnAndSettingMap = new HashMap();
        columnAndSettingMap.put("columns", columns);
        //获取当前表格用户自定义属性
        UserDefinedCenterDTO userDefined = getFieldSeqList(user, pageCode, tmProjectId, tmActivityId, table);
        List<UserDefinedCenterMetadataResult> metadataMetadataTagResults = userDefined.getMetadataTags();
        //解释用户自定义栏位
        if (CollectionUtils.isNotEmpty(metadataMetadataTagResults)) {
            //1、先排序
            sortTag(metadataMetadataTagResults);
            //2、获取字段属性和order值
            String userTable = "";
            for (UserDefinedCenterMetadataResult metadataTagResult : metadataMetadataTagResults) {
                Map<String, Object> oneMap = new HashMap<>();
                String schema = metadataTagResult.getResourceContent().getResponse();
                String path = metadataTagResult.getResourceContent().getResponse();
                if (metadataTagResult.getResourceContent().getResponse().contains(".")) {
                    String fieldNames[] = metadataTagResult.getResourceContent().getResponse().split("\\.");
                    schema = fieldNames[fieldNames.length - 1];
                    path = path.replaceFirst("." + schema, "");
                    if (StringUtils.isEmpty(userTable)) {
                        userTable = fieldNames[fieldNames.length - 2];
                    }
                }
                oneMap.put("schema", schema);
                oneMap.put("path", path);
                if (MapUtils.isNotEmpty(metadataTagResult.getExtendedAttributes())) {
                    Map<String, Object> extendedAttr = metadataTagResult.getExtendedAttributes();
                    if (extendedAttr.containsKey("hide")) {
                        oneMap.put("hide", Boolean.valueOf(extendedAttr.get("hide").toString()));
                    }
                    if (extendedAttr.containsKey("width")) {
                        // double --> int：去尾法
                        oneMap.put("width", Double.valueOf(extendedAttr.get("width").toString()).intValue());
//                        oneMap.put("width", Integer.valueOf(extendedAttr.get("width").toString()));
                    }
                    if (extendedAttr.containsKey("pinned")) {
                        oneMap.put("pinned", extendedAttr.get("pinned").toString());
                    }
                }
                if (CollectionUtils.isNotEmpty(metadataTagResult.getTags()) && !metadataTagResult.getTags().isEmpty()) {
                    int orderInt = Integer.parseInt(metadataTagResult.getTags().get(0).getValue());
                    oneMap.put("order", orderInt);
                }
                columns.add(oneMap);
                if (!StringUtils.isNotEmpty(table) || !table.equals(userTable)) {
                    table = userTable;
                }
            }
        }
        fieldArrMap.put(table, columnAndSettingMap);
        //获取setting
        JSONObject settings = new JSONObject();
        UserDefinedCenterDTO userDefinedSetting = getOrderConditionsByUser(user, pageCode, tmProjectId, tmActivityId, table);
        if (userDefinedSetting != null && userDefinedSetting.getSettings() != null) {
            if (StringUtils.isNotEmpty(table)) {
                settings = userDefinedSetting.getSettings().getJSONObject(table);
            } else {
                settings = userDefinedSetting.getSettings();
            }
        }
        columnAndSettingMap.put("settings", settings);
        return fieldArrMap;
    }


    /**
     * 排序
     *
     * @param fields
     */
    private void sortTag(List<UserDefinedCenterMetadataResult> fields) {
        fields.sort(((t0, t1) -> {
            List<ThemeMapTag> tag0 = t0.getTags();
            Integer a = 10000;
            if (!CollectionUtils.isEmpty(tag0)) {
                for (ThemeMapTag tag : tag0) {
                    if ("ORDER".equals(tag.getCode())) {
                        try {
                            a = Integer.parseInt(tag.getValue());
                        } catch (Exception e) {
                            a = 0;
                        }
                    }
                }
            }
            List<ThemeMapTag> tag1 = t1.getTags();
            Integer b = 10000;
            if (!CollectionUtils.isEmpty(tag1)) {
                for (ThemeMapTag tag : tag1) {
                    if ("ORDER".equals(tag.getCode())) {
                        try {
                            b = Integer.parseInt(tag.getValue());
                        } catch (Exception e) {
                            b = 0;
                        }
                    }
                }
            }
            return a - b;
        }));
    }

    private void setUserInfo(AuthoredUser user, UserDefinedCenterDTO userDefined) {
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
    }

    /**
     * 保存高级查询条件
     *
     * @param user
     * @param userDefined
     * @return
     */
    @Override
    public Map<String, Object> saveSearchConditions(AuthoredUser user, UserDefinedCenterDTO userDefined) {
        String tmActivityId = userDefined.getTmActivityId();
        // 作业code校验
        if (StringUtils.isBlank(tmActivityId)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(messageUtils.getMessage("exception.param.tmActivityId.null"));
        }
        String pageCode = userDefined.getPageCode();
        // 页面编码校验
        if (StringUtils.isBlank(pageCode)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(messageUtils.getMessage("exception.param.pageCode.null"));
        }
        String tableSchema = userDefined.getTableSchema();
        // 表格tableSchema校验
        if (StringUtils.isBlank(tableSchema)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(messageUtils.getMessage("exception.param.tableSchema.null"));
        }
        String name = userDefined.getName();
        // 名称校验
        if (StringUtils.isBlank(name)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(messageUtils.getMessage("exception.param.name.null"));
        }
        // 条件校验
        List<SearchConditionGroup> paramConditions = userDefined.getSearchConditions();
        if (CollectionUtils.isEmpty(paramConditions)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(messageUtils.getMessage("exception.param.searchCondition.null"));
        }
        // 存入当前用户租户
        setUserInfo(user, userDefined);
        // 名称是唯一的,校验名称是否重复
        List<UserDefinedPO> searchConditions = userDefinedMongoMapper.getSearchConditions(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
        if (CollectionUtils.isNotEmpty(searchConditions)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_DATA_REPEAT_ERROR.getBusinessException(messageUtils.getMessage("exception.param.name.repeat"));
        }
        Long id = userDefinedMongoMapper.saveSearchConditions(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
        HashMap<String, Object> result = Maps.newHashMap();
        result.put("uniqueId", id);
        return result;
    }

    /**
     * 删除表格高级查询常用条件配置
     *
     * @param user
     * @param uniqueId
     */
    @Override
    public void delSearchConditions(AuthoredUser user, Long uniqueId) {
        // 存入当前用户租户
        userDefinedMongoMapper.delSearchConditions(user, uniqueId);
    }

    /**
     * 查询表格高级查询常用条件配置
     *
     * @param user
     * @param userDefined
     * @return
     */
    @Override
    public List<UserDefinedCenterDTO> getSearchConditions(AuthoredUser user, UserDefinedCenterDTO userDefined) {
        // 存入当前用户租户
        List<UserDefinedPO> searchConditions = queryUserDefinedService.getSearchConditions(user, DataConverter.INSTANCE.toUserDefinedPO(userDefined));
        if (CollectionUtils.isNotEmpty(searchConditions)) {
            return searchConditions.stream().map(DataConverter.INSTANCE::toUserDefinedCenterDTO).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    @Override
    public void saveGridItems(UserGridDTO userGridDTO, AuthoredUser user) {
        userGridDTO.setUserId(user.getUserId());
        userGridDTO.setTenantId(user.getTenantId());
        try {
            userDefinedMongoMapper.saveGridItems(DataConverter.INSTANCE.toUserGridPO(userGridDTO));
        } catch (Exception e) {
            logger.error(" save grid items error: {}", e.getMessage());
        }
    }

    @Override
    public UserGridDTO getGridItems(UserGridDTO userGridDTO) {
        UserGridPO gridItems = queryUserDefinedService.getGridItems(DataConverter.INSTANCE.toUserGridPO(userGridDTO));
        return DataConverter.INSTANCE.toUserGridDTO(gridItems);
    }

    @Override
    public void delGridItems(Long uniqueId, AuthoredUser user) {
        userDefinedMongoMapper.delGridByUniqueId(uniqueId, user);
    }
}
