package com.digiwin.athena.base.application.service.userdefined;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.base.infrastructure.meta.po.userdefined.mongo.UserOperateRecordDTO;
import com.digiwin.athena.base.infrastructure.mongo.UserDefinedMongoMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class UserOperateRecordService {
    private String COLLECTION_NAME = "userOperateRecord";

    @Autowired
    private UserDefinedMongoMapper userDefinedMongoMapper;

    public void save(UserOperateRecordDTO userOperateRecordDTO) {
        // 先删记录
        Query query = buildQuery(userOperateRecordDTO);
        if ("sort".equals(userOperateRecordDTO.getType())) {
            if (StringUtils.isBlank(userOperateRecordDTO.getCode())) {
                throw BusinessException.create(1006, "Sort type code is not null");
            }
            query.addCriteria(Criteria.where("code").is(userOperateRecordDTO.getCode()));
        }
        userDefinedMongoMapper.getUserDefinedMongoTemplate().remove(query, UserOperateRecordDTO.class, COLLECTION_NAME);
        userDefinedMongoMapper.getUserDefinedMongoTemplate().save(userOperateRecordDTO, COLLECTION_NAME);
    }

    private Query buildQuery(UserOperateRecordDTO userOperateRecordDTO) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        userOperateRecordDTO.setUserId(authoredUser.getUserId());
        userOperateRecordDTO.setTenantId(authoredUser.getTenantId());
        userOperateRecordDTO.setCreateTime(new Date());
        Query query = new Query();
        query.addCriteria(Criteria.where("userId").is(userOperateRecordDTO.getUserId()))
                .addCriteria(Criteria.where("tenantId").is(userOperateRecordDTO.getTenantId()))
                .addCriteria(Criteria.where("pageCode").is(userOperateRecordDTO.getPageCode()))
                .addCriteria(Criteria.where("type").is(userOperateRecordDTO.getType()));
        return query;
    }

    public UserOperateRecordDTO findOne(UserOperateRecordDTO userOperateRecordDTO) {
        List<UserOperateRecordDTO> userOperateRecordDTOS = findList(userOperateRecordDTO);
        return CollectionUtils.isNotEmpty(userOperateRecordDTOS) ? userOperateRecordDTOS.get(0) : null;
    }

    public List<UserOperateRecordDTO> findList(UserOperateRecordDTO userOperateRecordDTO) {
        Query query = buildQuery(userOperateRecordDTO);
        query.fields().include("pageCode").include("code").include("type").include("records");
        query.with(Sort.by(Sort.Order.desc("_id")));
        return userDefinedMongoMapper.getUserDefinedMongoTemplate().find(query, UserOperateRecordDTO.class, COLLECTION_NAME);
    }

}
