package com.digiwin.athena.base.application.manager.dmc;

import com.digiwin.athena.base.application.meta.request.attachment.DmcAccount;
import com.digiwin.athena.base.application.meta.request.attachment.ShareAttachmentDTO;
import com.digiwin.athena.base.application.meta.request.attachment.UploadParamDTO;
import com.digiwin.athena.base.application.meta.response.attachment.ShareAttachmentRespDTO;
import com.digiwin.athena.base.application.meta.response.attachment.UploadAttachmentRespDTO;
import org.springframework.http.ResponseEntity;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * DmcService Description
 *
 * @author majianfu
 * @date 2022/3/7
 * @since
 */
public interface DmcService {
    /**
     * 登录dmc 获取token
     *
     * @return
     */
    String login(String account, String password);

    /**
     * 删除附件
     *
     * @param token   dmc登录后返回的token
     * @param dirIds  目录id列表，可为空
     * @param fileIds 文件id列表，不可为空
     */
    void deleteAttachment(String token, Collection<String> dirIds, Collection<String> fileIds);

    void deleteAgileData(String token, Collection<String> dirIds, Collection<String> fileIds);

    /**
     * 登录并删除附件信息</br>
     *
     * @param dirIds  目录id列表，可为空
     * @param fileIds 文件id列表，不可为空
     */
    void loginAndDeleteAttachment(Collection<String> dirIds, Collection<String> fileIds, DmcAccount dmcAccount);

    /**
     * 上传附件到文档中心
     *
     * @param uploadParamDTO
     * @return
     */
    UploadAttachmentRespDTO uploadAttachment(UploadParamDTO uploadParamDTO);

    /**
     * 分享文件
     *
     * @param shareAttachmentDTO
     * @return
     */
    List<ShareAttachmentRespDTO> shareAttachment(ShareAttachmentDTO shareAttachmentDTO);

    /**
     * 上传文件并分享
     *
     * @param uploadParamDTO
     * @return
     */
    Optional<ShareAttachmentRespDTO> uploadAndShareAttachment(UploadParamDTO uploadParamDTO);


    /**
     * 文件预览
     *
     * @param fileId
     * @return
     */
    InputStream previewFile(String fileId);

    /**
     * 文件删除
     *
     * @param fileId
     */
    Map<String, Object> deleteFile(String fileId);


    ResponseEntity<byte[]> getAttachment(String fileId, String token);

    /**
     * 批量下载附件
     *
     * @param param
     * @param token
     * @return
     */
    byte[] getMultiAttachment(Map<String, Object> param, String token);

}
