package com.digiwin.athena.base.application.service.principal;

import com.digiwin.athena.base.application.meta.request.principal.TaskTypeQueryReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoSaveReq;
import com.digiwin.athena.base.application.meta.response.audc.TaskTypeQueryResp;
import com.digiwin.athena.base.infrastructure.meta.bo.principal.ThePrincipalTaskNum;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocEmpInfoDTO;

import java.util.List;

/**
 * PrincipalTaskTypeService Description
 *
 * @author chenpeng
 * @date 2024年8月26日
 * @since
 */
public interface PrincipalTaskTypeService {

    /**
     * 保存 被代理人可被代理的任务类型
     *
     * @param agentId           代理人
     * @param userId            被代理人
     * @param taskDefCodes      不可被代理的任务类型
     * @param tenantId          租户id
     * @param calendarTaskCodes 无权代理的行事历任务列表
     */
    void saveTaskType(String agentId, String userId, List<String> taskDefCodes, String tenantId, List<String> calendarTaskCodes);

    /**
     * 查询 被代理人不可被代理的任务类型
     *
     * @param taskTypeQueryReq
     * @param tenantId
     * @return
     */
    List<TaskTypeQueryResp> queryTaskType(TaskTypeQueryReq taskTypeQueryReq, String tenantId);

    List<ThePrincipalTaskNum> queryTaskTypeNum(List<EocEmpInfoDTO> agentEmpList, String tenantId);

    /**
     * 批量保存 被代理人可被代理的任务类型
     *
     * @param needSaveList
     * @param tenantId     租户id
     */
    void batchSaveTaskType(List<ProxyInfoSaveReq> needSaveList, String tenantId);

    /**
     * 批量删除被代理人的任务类型
     *
     * @param clearList
     * @param tenantId
     */
    void batchDeleteTaskType(List<String> clearList, String tenantId);
}
