/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.config;

import com.digiwin.athena.appcore.exception.GlobalExceptionHandler;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.google.common.eventbus.AsyncEventBus;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@Configuration
public class CustomerWebMvcConfigurationSupport
extends WebMvcConfigurationSupport {
    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> httpMessageConverter : converters) {
            if (!MappingJackson2HttpMessageConverter.class.isInstance(httpMessageConverter)) continue;
            ((MappingJackson2HttpMessageConverter)httpMessageConverter).setObjectMapper(JsonUtils.createObjectMapper());
        }
    }

    @Bean
    MessageUtils messageUtils(MessageSource messageSource, AsyncEventBus eventBus) {
        return new MessageUtils(messageSource);
    }

    @Bean
    GlobalExceptionHandler globalExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"POST", "GET", "PUT", "OPTIONS", "DELETE"}).maxAge(3600L).allowCredentials(true);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeInterceptor = new LocaleChangeInterceptor();
        localeInterceptor.setParamName("lang");
        registry.addInterceptor((HandlerInterceptor)localeInterceptor);
    }

    @Bean
    public LocaleResolver localeResolver() {
        AcceptHeaderLocaleResolver localeResolver = new AcceptHeaderLocaleResolver(){

            public Locale resolveLocale(HttpServletRequest request) {
                if (StringUtils.isNotBlank((CharSequence)request.getHeader("locale"))) {
                    return Locale.forLanguageTag(request.getHeader("locale").replace('_', '-'));
                }
                return this.getDefaultLocale();
            }
        };
        localeResolver.setDefaultLocale(Locale.getDefault());
        return localeResolver;
    }
}

