/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.importstatistics.application;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.ServiceException;
import com.digiwin.athena.atdm.importstatistics.application.Application;
import com.digiwin.athena.atdm.importstatistics.application.FieldDescription;
import com.digiwin.athena.atdm.importstatistics.cac.DataEntryCacService;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.kg.DataEntryKgService;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationRespDTO;
import com.digiwin.athena.atdm.importstatistics.util.LanguageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApplicationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationService.class);
    @Autowired
    private DataEntryKgService kgService;
    @Autowired
    private DataEntryCacService cacService;

    public List<Application> getApplications(AuthoredUser user) {
        List<Application> applications = this.getByNameAndTags(null, null);
        List<Application> filteredApplications = this.filterApplicationByTenant(applications, user.getTenantId());
        List<Application> enhanceApplications = this.processEnhanceApplication(filteredApplications);
        return enhanceApplications;
    }

    public List<Application> getByNameAndTags(String applicationName, List<String> tags) {
        List applications = null;
        DapResponse re = this.kgService.getApplicationByNameAndTags(applicationName, tags);
        if (re.getStatus() != 200) {
            throw new ServiceException(Integer.valueOf(-1), re.getErrorMessage());
        }
        if (re.getResponse() != null) {
            applications = (List)re.getResponse();
        }
        if (applications != null && !applications.isEmpty()) {
            for (Application app : applications) {
                try {
                    LanguageUtil.processLocaleLanguage((Object)app, (String)LocaleContextHolder.getLocale().toString());
                }
                catch (Exception e) {
                    log.error("error parse application language", (Throwable)e);
                }
            }
        }
        return applications;
    }

    public List<Application> filterApplicationByTenant(List<Application> applications, String tenantId) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(applications)) {
            return applications;
        }
        Set<String> matchApplicationCodes = this.findApplicationCodeByTenantId(tenantId);
        List<Application> filteredApplication = applications.stream().filter(e -> matchApplicationCodes.contains(e.getCode())).collect(Collectors.toList());
        return filteredApplication;
    }

    public Set<String> findApplicationCodeByTenantId(String tenantId) {
        return this.cacService.getAithorizationsApplication(tenantId);
    }

    public List<Application> processEnhanceApplication(List<Application> applications) {
        ArrayList<Application> re = new ArrayList<Application>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(applications)) {
            HashSet<String> appCode = new HashSet<String>();
            HashSet<String> enhanceCode = new HashSet<String>();
            for (Application app : applications) {
                if (StringUtils.isEmpty((CharSequence)app.getCategory())) {
                    appCode.add(app.getCode());
                    re.add(app);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"enhance", (CharSequence)app.getCategory())) continue;
                enhanceCode.add(app.getCode());
            }
            DapResponse resp = this.kgService.getDigitalStaff(appCode, enhanceCode);
            if (resp == null || resp.getStatus() != 200) {
                throw BusinessException.create((String)ErrorCodeEnum.KG_V2_GET_DIGITAL_STAFF.getErrCode(), (String)(resp == null ? "NULL" : resp.getErrorMessage()));
            }
            Map enhanceMap = (Map)resp.getResponse();
            if (enhanceMap != null && !enhanceMap.isEmpty() && org.apache.commons.collections.CollectionUtils.isNotEmpty(re)) {
                for (Application i : re) {
                    i.setEnhance((List)enhanceMap.get(i.getCode()));
                    this.setEnhanceParam(i);
                }
            }
        }
        return re;
    }

    private void setEnhanceParam(Application app) {
        List<Application> filterApps;
        DapResponse respEnhance = this.kgService.getEnhancebyAppCode(app.getCode());
        if (null != respEnhance.getResponse() && org.apache.commons.collections.CollectionUtils.isNotEmpty(filterApps = this.filterApplicationByTenant((List)respEnhance.getResponse(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId()))) {
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)app.getParamDescription())) {
                ArrayList paras = new ArrayList();
                app.setParamDescription(paras);
            }
            for (Application i : filterApps) {
                if (CollectionUtils.isEmpty((Collection)i.getParamDescription())) continue;
                for (FieldDescription p : i.getParamDescription()) {
                    p.setEnhance(String.format("%s:%s", i.getName(), i.getExtendDisplay()));
                }
                app.getParamDescription().addAll(i.getParamDescription());
            }
        }
    }

    public List<ApplicationRelationRespDTO> getApplicationRelationsByCodesAndType(List<String> code, String type) {
        DapResponse dapResponse = this.kgService.postApplicationRelationsByCodesAndType(code, type);
        return null != dapResponse.getResponse() ? (List)dapResponse.getResponse() : new ArrayList();
    }
}

