/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.permission;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.application.meta.request.permission.TypeActivities;
import com.digiwin.athena.base.application.meta.request.permission.TypeActivitiesAccessible;
import com.digiwin.athena.base.application.meta.response.permission.ActivityAccessible;
import com.digiwin.athena.base.application.service.permission.PermissionCheckService;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.iam.service.BaseIamService;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.AuthorityConfigResp;
import com.digiwin.athena.base.infrastructure.manager.uibot.BaseReportService;
import com.digiwin.athena.cac.sdk.manager.CacManager;
import com.digiwin.athena.cac.sdk.meta.dto.response.AppAuthDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PermissionCheckServiceImpl
implements PermissionCheckService {
    @Generated
    private static final Logger log = LogManager.getLogger(PermissionCheckServiceImpl.class);
    @Resource
    private BaseIamService userPermissionService;
    @Resource
    private BaseThemeMapService baseThemeMapService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BaseReportService baseReportService;
    private static final String ACCESS_FORBIDDEN = "forbidden";
    private static final String SEPARATOR = ":";
    private static final String EFFECT = "effect";
    private static final String CONDITIONS = "conditions";
    private static final String ID = "id";
    private static final String MODULE_ID = "moduleId";
    private static final String ENABLE = "enable";
    private static final String MODULE_ENABLE = "module-enable";
    private static final String ATHENA_DDSM_DESIGNER = "athena-ddsmdesigner";
    private static final String RESET_TEST_DATA = "resetTestData";
    private static final String REPORT_PARAMETER_MAINTENANCE = "report-parameter-maintenance";
    private static final String REPORT_FUNCTIONAL_DESIGN = "report-functional-design";

    @Override
    @Deprecated
    public List<ActivityAccessible> checkActivityAccessible(AuthoredUser authoredUser, List<String> tmActivityIdList) {
        log.info("check user({}) activity access permission for: {}", (Object)authoredUser.getUserId(), tmActivityIdList);
        if (CollectionUtils.isEmpty(tmActivityIdList)) {
            return Collections.emptyList();
        }
        List<AuthorityConfigResp> accessAuthConfigList = this.getActivityAuthorityConfig(tmActivityIdList);
        TypeActivities typeActivities = new TypeActivities();
        typeActivities.setTmActivityIdList(tmActivityIdList);
        return this.checkActivityAccessible(authoredUser, Collections.singletonList(typeActivities), accessAuthConfigList);
    }

    private List<AuthorityConfigResp> getActivityAuthorityConfig(List<String> tmActivityIdList) {
        if (CollectionUtils.isNotEmpty(tmActivityIdList)) {
            return this.baseThemeMapService.getActivityAuthorityConfig(tmActivityIdList, LocaleContextHolder.getLocale().toString());
        }
        return Lists.newArrayList();
    }

    private List<AuthorityConfigResp> getTaskAuthorityConfig(List<String> tmTaskIdList) {
        if (CollectionUtils.isNotEmpty(tmTaskIdList)) {
            return this.baseThemeMapService.getTaskAuthorityConfig(tmTaskIdList, LocaleContextHolder.getLocale().toString());
        }
        return Lists.newArrayList();
    }

    private List<ActivityAccessible> checkActivityAccessible(AuthoredUser authoredUser, List<TypeActivities> typeActivitiesList, List<AuthorityConfigResp> accessAuthConfigList) {
        HashMap<String, List<AuthorityConfigResp>> needConfirmedMap = new HashMap<String, List<AuthorityConfigResp>>();
        ArrayList<String> allowedActivityIdList = new ArrayList<String>();
        this.analyzeActivityAuthorityConfig(typeActivitiesList, accessAuthConfigList, needConfirmedMap, allowedActivityIdList);
        ArrayList<ActivityAccessible> permissionCheckResultList = new ArrayList<ActivityAccessible>();
        if (MapUtils.isNotEmpty(needConfirmedMap)) {
            Set entrySet = needConfirmedMap.entrySet();
            for (Map.Entry entry : entrySet) {
                permissionCheckResultList.addAll(this.callIamToCheckAccessPermission(authoredUser, (String)entry.getKey(), (List)entry.getValue()));
            }
        }
        for (String allowedActivityId : allowedActivityIdList) {
            permissionCheckResultList.add(new ActivityAccessible(allowedActivityId, "allow"));
        }
        return permissionCheckResultList;
    }

    private void analyzeActivityAuthorityConfig(List<TypeActivities> typeActivitiesList, List<AuthorityConfigResp> activityAuthorityConfigList, Map<String, List<AuthorityConfigResp>> needConfirmedMap, List<String> allowedActivityIdList) {
        if (CollectionUtils.isNotEmpty(activityAuthorityConfigList)) {
            List legalActivityIdList = activityAuthorityConfigList.stream().map(AuthorityConfigResp::getCode).collect(Collectors.toList());
            HashMap activityPermissionCheckMap = new HashMap();
            typeActivitiesList.stream().forEach(typeActivities -> {
                for (String activityId : typeActivities.getTmActivityIdList()) {
                    if (legalActivityIdList.contains(activityId)) {
                        activityPermissionCheckMap.put(activityId, typeActivities.getPermissionCheckList());
                        continue;
                    }
                    allowedActivityIdList.add(activityId);
                }
            });
            for (AuthorityConfigResp activityAuthorityConfig : activityAuthorityConfigList) {
                String authorityPrefix = activityAuthorityConfig.getAuthorityPrefix();
                if (StringUtils.isBlank((CharSequence)authorityPrefix)) {
                    allowedActivityIdList.add(activityAuthorityConfig.getCode());
                    continue;
                }
                if (!authorityPrefix.contains(SEPARATOR)) {
                    throw AudcErrorCodeEnum.AUTH_PREFIX_CONFIG_ERROR.getBusinessException(this.messageUtils.getMessageWithFormat("exception.authority.prefix.config.error", new Object[]{activityAuthorityConfig.getCode(), authorityPrefix}));
                }
                String appCode = authorityPrefix.substring(0, authorityPrefix.indexOf(SEPARATOR));
                List needConfirmedList = needConfirmedMap.computeIfAbsent(appCode, key -> new ArrayList());
                activityAuthorityConfig.setPermissionCheckList((List)activityPermissionCheckMap.get(activityAuthorityConfig.getCode()));
                needConfirmedList.add(activityAuthorityConfig);
            }
        } else {
            typeActivitiesList.stream().map(TypeActivities::getTmActivityIdList).forEach(activityIdList -> allowedActivityIdList.addAll((Collection<String>)activityIdList));
        }
    }

    @Override
    public List<TypeActivitiesAccessible> checkTypeActivitiesAccessible(AuthoredUser authoredUser, List<TypeActivities> typeActivitiesList) {
        ArrayList<TypeActivities> typeActivitiesListTmp = new ArrayList<TypeActivities>();
        for (TypeActivities typeActivities2 : typeActivitiesList) {
            if (!CollectionUtils.isNotEmpty(typeActivities2.getTmActivityIdList())) continue;
            typeActivitiesListTmp.add(typeActivities2);
        }
        ArrayList<String> taskIdList = new ArrayList<String>();
        ArrayList<String> activityIdList = new ArrayList<String>();
        typeActivitiesListTmp.stream().filter(typeActivities -> CollectionUtils.isNotEmpty(typeActivities.getTmActivityIdList())).forEach(typeActivities -> {
            if (null != typeActivities.getCategory() && TypeActivities.CATEGORY_PROJECT.equals(typeActivities.getCategory())) {
                taskIdList.addAll(typeActivities.getTmActivityIdList());
            } else {
                activityIdList.addAll(typeActivities.getTmActivityIdList());
            }
        });
        ArrayList<AuthorityConfigResp> authorityConfigList = new ArrayList<AuthorityConfigResp>();
        authorityConfigList.addAll(this.getActivityAuthorityConfig(activityIdList));
        authorityConfigList.addAll(this.getTaskAuthorityConfig(taskIdList));
        List<ActivityAccessible> activityAccessibleList = this.checkActivityAccessible(authoredUser, typeActivitiesListTmp, authorityConfigList);
        Map activityAccessMap = activityAccessibleList.stream().collect(Collectors.toMap(ActivityAccessible::getTmActivityId, Function.identity(), (key1, key2) -> key2));
        ArrayList<TypeActivitiesAccessible> typeActivitiesAccessibleList = new ArrayList<TypeActivitiesAccessible>(typeActivitiesList.size());
        for (TypeActivities typeActivities3 : typeActivitiesListTmp) {
            if (CollectionUtils.isEmpty(typeActivities3.getTmActivityIdList())) continue;
            List<String> tmActivityIdList = typeActivities3.getTmActivityIdList();
            TypeActivitiesAccessible typeActivitiesAccessible = new TypeActivitiesAccessible(typeActivities3.getType(), Lists.newArrayListWithCapacity((int)tmActivityIdList.size()));
            for (String tmActivityId : typeActivities3.getTmActivityIdList()) {
                typeActivitiesAccessible.getActivityAccessibleList().add((ActivityAccessible)activityAccessMap.get(tmActivityId));
            }
            typeActivitiesAccessibleList.add(typeActivitiesAccessible);
        }
        return typeActivitiesAccessibleList;
    }

    private List<ActivityAccessible> callIamToCheckAccessPermission(AuthoredUser authoredUser, String appCode, List<AuthorityConfigResp> activityAuthConfigList) {
        JSONArray permissions = this.getAppAllPermissions(authoredUser, appCode);
        ArrayList<ActivityAccessible> permissionCheckResultList = new ArrayList<ActivityAccessible>(activityAuthConfigList.size());
        for (AuthorityConfigResp authConfig : activityAuthConfigList) {
            boolean effect = true;
            int denyReason = 0;
            HashMap<String, String> permissionCheckMap = new HashMap<String, String>();
            if (null != permissions && !permissions.isEmpty()) {
                String appModule = authConfig.getAuthorityPrefix();
                for (int idx = 0; idx < permissions.size(); ++idx) {
                    String fullPath;
                    JSONObject permissionJson = permissions.getJSONObject(idx);
                    if (permissionJson == null || permissionJson.isNullObject()) {
                        log.warn("activityAuthConfigList\u4e2d\u7684\u7b2c{}\u4e2apermissionJson\u4e3a\u7a7a", (Object)idx);
                        continue;
                    }
                    JSONObject conditions = permissionJson.getJSONObject(CONDITIONS);
                    if (!this.jsonContainsJsonObj(conditions, fullPath = "drn:iam:app:" + appModule + SEPARATOR + authConfig.getCode())) continue;
                    effect = StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)permissionJson.getString(EFFECT));
                    if (!effect && permissionJson.containsKey((Object)"denyReason")) {
                        denyReason = permissionJson.getInt("denyReason");
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)authConfig.getPermissionCheckList())) break;
                    JSONObject permissionList = conditions.getJSONObject(fullPath);
                    for (String permissionCheck : authConfig.getPermissionCheckList()) {
                        if (!permissionList.containsKey((Object)permissionCheck)) continue;
                        permissionCheckMap.put(permissionCheck, permissionList.getString(permissionCheck));
                    }
                    break;
                }
            }
            String access = effect ? "allow" : (denyReason == 0 ? ACCESS_FORBIDDEN : "NOBUY");
            permissionCheckResultList.add(new ActivityAccessible(authConfig.getCode(), access, permissionCheckMap));
        }
        return permissionCheckResultList;
    }

    private boolean jsonContainsJsonObj(JSONObject jsonObj, String key) {
        return null != jsonObj && jsonObj.containsKey((Object)key) && null != jsonObj.getJSONObject(key);
    }

    private JSONArray getAppAllPermissions(AuthoredUser authoredUser, String appCode) {
        String value;
        String redisKey = "Athena:agileInteraction:audc:cache:" + authoredUser.getTenantId() + SEPARATOR + authoredUser.getUserId() + SEPARATOR + appCode;
        if (Boolean.TRUE.equals(this.stringRedisTemplate.hasKey((Object)redisKey)) && StringUtils.isNotBlank((CharSequence)(value = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey)))) {
            JSONArray jsonArray = JSONArray.fromObject((Object)value);
            log.info("redis\u91cc\u7684permissionList:{}", (Object)value);
            return jsonArray;
        }
        JSONObject permissionJsonObj = this.userPermissionService.getAllUserPermissionV2(authoredUser, appCode);
        if (null != permissionJsonObj && permissionJsonObj.containsKey((Object)"data")) {
            JSONArray permissionList = permissionJsonObj.getJSONArray("data");
            log.debug("user({}) app authority config: {}", (Object)authoredUser.getUserId(), (Object)permissionList);
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)JsonUtils.objectToString((Object)permissionList), 60L, TimeUnit.SECONDS);
            return permissionList;
        }
        return null;
    }

    @Override
    public Map<String, String> checkActivitiesAccessible(AuthoredUser authoredUser, Integer category, List<String> activityIdList) {
        TypeActivities typeActivities = new TypeActivities();
        typeActivities.setType("activityType");
        typeActivities.setCategory(category);
        typeActivities.setTmActivityIdList(activityIdList);
        List<TypeActivitiesAccessible> typeActivitiesAccessible = this.checkTypeActivitiesAccessible(authoredUser, Collections.singletonList(typeActivities));
        HashMap<String, String> activityPermissionMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(typeActivitiesAccessible) && CollectionUtils.isNotEmpty(typeActivitiesAccessible.get(0).getActivityAccessibleList())) {
            typeActivitiesAccessible.get(0).getActivityAccessibleList().forEach(activityAccessible -> activityPermissionMap.put(activityAccessible.getTmActivityId(), activityAccessible.getAccess()));
        }
        return activityPermissionMap;
    }

    @Override
    public Map<String, List<String>> getModuleOrMenuAccessible(AuthoredUser authoredUser, String appCode) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        JSONArray accessibleArray = this.getAppAllPermissions(authoredUser, appCode);
        if (null == accessibleArray) {
            return resultMap;
        }
        Map<String, Boolean> specialMenuMap = this.getSpecialMenuAccessible(authoredUser);
        ArrayList<String> allModuleList = new ArrayList<String>();
        ArrayList<String> moduleAccessibleList = new ArrayList<String>();
        ArrayList<String> allMenuList = new ArrayList<String>();
        ArrayList<String> menuAccessibleList = new ArrayList<String>();
        specialMenuMap.forEach((menuId, accessible) -> allMenuList.add((String)menuId));
        for (Object item : accessibleArray) {
            String fullPath;
            JSONObject conditions;
            if (Objects.isNull(item) || item instanceof JSONNull) continue;
            JSONObject accessibleObj = (JSONObject)item;
            if (StringUtils.equalsIgnoreCase((CharSequence)MODULE_ENABLE, (CharSequence)accessibleObj.getString(ID))) {
                allModuleList.add(accessibleObj.getString(MODULE_ID));
            } else {
                allMenuList.add(accessibleObj.getString(ID));
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)accessibleObj.getString(EFFECT)) || !this.jsonContainsJsonObj(conditions = accessibleObj.getJSONObject(CONDITIONS), fullPath = "drn:iam:app:Athena:" + accessibleObj.getString(MODULE_ID) + SEPARATOR + accessibleObj.getString(ID)) || null == conditions.getJSONObject(fullPath).get(ENABLE) || !StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)conditions.getJSONObject(fullPath).getString(ENABLE)) || specialMenuMap.containsKey(accessibleObj.getString(ID)) && !specialMenuMap.get(accessibleObj.getString(ID)).booleanValue()) continue;
            if (StringUtils.equalsIgnoreCase((CharSequence)MODULE_ENABLE, (CharSequence)accessibleObj.getString(ID))) {
                moduleAccessibleList.add(accessibleObj.getString(MODULE_ID));
                continue;
            }
            menuAccessibleList.add(accessibleObj.getString(ID));
        }
        resultMap.put("allModule", allModuleList);
        resultMap.put("allMenu", allMenuList);
        resultMap.put("accessibleModule", moduleAccessibleList);
        resultMap.put("accessibleMenu", menuAccessibleList);
        return resultMap;
    }

    private Map<String, Boolean> getSpecialMenuAccessible(AuthoredUser authoredUser) {
        HashMap<String, Boolean> specialMenuMap = new HashMap<String, Boolean>();
        AppAuthDTO appAuthDTO = CacManager.queryAppAuth((String)authoredUser.getUserId(), (String)"EAS");
        specialMenuMap.put(ATHENA_DDSM_DESIGNER, Objects.nonNull(appAuthDTO) ? appAuthDTO.getIsSuccess() : false);
        Boolean isSysRole = this.baseReportService.isSysRole(authoredUser);
        specialMenuMap.put(REPORT_PARAMETER_MAINTENANCE, BooleanUtils.isTrue((Boolean)isSysRole));
        specialMenuMap.put(REPORT_FUNCTIONAL_DESIGN, BooleanUtils.isTrue((Boolean)isSysRole));
        return specialMenuMap;
    }
}

