/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.permission;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.base.application.meta.response.permission.ActionPermissionDTO;
import com.digiwin.athena.base.application.meta.response.permission.FunctionPermissionDTO;
import com.digiwin.athena.base.application.service.permission.PermissionService;
import com.digiwin.athena.base.infrastructure.manager.iam.model.AppAuthoredDTO;
import com.digiwin.athena.base.infrastructure.manager.iam.service.BaseIamService;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.config.JaProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PermissionServiceImpl
implements PermissionService {
    @Resource
    private BaseIamService baseIamService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public List<FunctionPermissionDTO> getUserAuthoredAppPermission(AuthoredUser authoredUser) {
        List<String> authoredAppCodeList = this.getUserAuthoredAppCode(authoredUser.getToken());
        if (CollectionUtils.isEmpty(authoredAppCodeList)) {
            return Collections.emptyList();
        }
        JSONArray userAppPermissionList = this.batchQueryUserAppPermission(authoredUser, authoredAppCodeList);
        if (null == userAppPermissionList || userAppPermissionList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.convertToFunctionPermissionDTO(userAppPermissionList);
    }

    @Override
    public List<FunctionPermissionDTO> getUserAuthoredAppPermissionByAppCode(AuthoredUser authoredUser, String appCode) {
        if (StringUtils.isEmpty((CharSequence)appCode)) {
            return Collections.emptyList();
        }
        JSONArray userAppPermissionList = this.batchQueryUserAppPermission(authoredUser, Lists.newArrayList((Object[])new String[]{appCode}));
        if (null == userAppPermissionList || userAppPermissionList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.convertToFunctionPermissionDTO(userAppPermissionList);
    }

    private List<FunctionPermissionDTO> convertToFunctionPermissionDTO(JSONArray userAppPermissionList) {
        ArrayList<FunctionPermissionDTO> resultList = new ArrayList<FunctionPermissionDTO>();
        for (int idx = 0; idx < userAppPermissionList.size(); ++idx) {
            JSONObject userAppPermission = userAppPermissionList.getJSONObject(idx);
            JSONArray permissions = userAppPermission.getJSONArray("permissions");
            if (permissions.isEmpty()) continue;
            String appCode = userAppPermission.getString("sysId");
            resultList.addAll(this.resolveFunctionPermission(appCode, permissions));
        }
        return resultList;
    }

    private List<FunctionPermissionDTO> resolveFunctionPermission(String appCode, JSONArray permissions) {
        ArrayList<FunctionPermissionDTO> resultList = new ArrayList<FunctionPermissionDTO>();
        for (int idx = 0; idx < permissions.size(); ++idx) {
            String target;
            JSONObject actionJSON;
            JSONObject conditions;
            JSONObject permission = permissions.getJSONObject(idx);
            if (permission.isEmpty() || !permission.containsKey((Object)"conditions") || (conditions = permission.getJSONObject("conditions")).isEmpty() || (actionJSON = conditions.getJSONObject(target = permission.getString("target"))).isEmpty()) continue;
            FunctionPermissionDTO functionPermission = new FunctionPermissionDTO();
            functionPermission.setAppCode(appCode);
            functionPermission.setAction(new ArrayList<ActionPermissionDTO>());
            String moduleCode = permission.getString("moduleId");
            functionPermission.setModuleCode(moduleCode);
            String functionId = permission.getString("id");
            functionPermission.setCode(functionId);
            String effect = permission.getString("effect");
            Iterator keyIterator = actionJSON.keys();
            while (keyIterator.hasNext()) {
                String actionCode = keyIterator.next().toString();
                String actionValue = actionJSON.getString(actionCode);
                ActionPermissionDTO actionPermission = new ActionPermissionDTO();
                actionPermission.setId(actionCode);
                actionPermission.setRestriction("allow".equalsIgnoreCase(effect) ? actionValue : effect);
                functionPermission.getAction().add(actionPermission);
            }
            resultList.add(functionPermission);
        }
        return resultList;
    }

    public List<String> getUserAuthoredAppCode(String token) {
        List authoredAppList = this.baseIamService.getUserAuthoredApp(token);
        if (CollectionUtils.isNotEmpty((Collection)authoredAppList)) {
            return authoredAppList.stream().filter(authoredApp -> BooleanUtils.isNotTrue((Boolean)authoredApp.getExpired())).map(AppAuthoredDTO::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void batchGetAppAccessible(AuthoredUser authoredUser, List<String> appCodes) {
        JSONArray userAppPermissionList = this.batchQueryUserAppPermission(authoredUser, appCodes);
        if (null == userAppPermissionList || userAppPermissionList.isEmpty()) {
            return;
        }
        for (int i = 0; i < userAppPermissionList.size(); ++i) {
            JSONObject userAppPermission = userAppPermissionList.getJSONObject(i);
            String userId = userAppPermission.getString("userId");
            String appCode = userAppPermission.getString("sysId");
            JSONArray permissionList = userAppPermission.getJSONArray("permissions");
            String redisKey = "Athena:agileInteraction:audc:cache:" + authoredUser.getTenantId() + ":" + userId + ":" + appCode;
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)JsonUtils.objectToString((Object)permissionList), 60L, TimeUnit.SECONDS);
        }
    }

    private JSONArray batchQueryUserAppPermission(AuthoredUser authoredUser, List<String> authoredAppCodeList) {
        JSONArray batchQueryUserAppPermission = new JSONArray();
        List userPartitionIds = Lists.partition(authoredAppCodeList, (int)JaProperty.getInteger((String)"audc.appPermission.pageSize", (Integer)100));
        userPartitionIds.forEach(appCodeList -> {
            JSONArray jsonArray = this.baseIamService.batchQueryUserAppPermission(authoredUser, appCodeList);
            if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
                batchQueryUserAppPermission.addAll((Collection)jsonArray);
            }
        });
        return batchQueryUserAppPermission;
    }
}

