/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.trial;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.request.trial.scene.TrialSceneReq;
import com.digiwin.athena.base.application.meta.request.trial.scene.TrialSceneResp;
import com.digiwin.athena.base.application.meta.request.trial.sceneStep.TrialSceneStepBindReq;
import com.digiwin.athena.base.application.meta.request.trial.step.TrialStepResp;
import com.digiwin.athena.base.application.service.trial.TrialSceneService;
import com.digiwin.athena.base.application.service.trial.TrialStepService;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialSceneMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialSceneStepMapper;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialSceneData;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialSceneStepData;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TrialSceneServiceImpl
implements TrialSceneService {
    private final TrialSceneMapper trialSceneMapper;
    private final TrialSceneStepMapper trialSceneStepMapper;
    private final TrialStepService trialStepService;

    @Autowired
    public TrialSceneServiceImpl(TrialStepService trialStepService, TrialSceneMapper trialSceneMapper, TrialSceneStepMapper trialSceneStepMapper) {
        this.trialSceneMapper = trialSceneMapper;
        this.trialSceneStepMapper = trialSceneStepMapper;
        this.trialStepService = trialStepService;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public Long add(TrialSceneReq sceneReq) {
        TrialSceneData sceneData = new TrialSceneData();
        BeanUtils.copyProperties((Object)sceneReq, (Object)sceneData);
        sceneData.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        sceneData.setCreateDate(LocalDateTime.now());
        sceneData.setModifyDate(LocalDateTime.now());
        int result = this.trialSceneMapper.insert((Object)sceneData);
        return sceneData.getId();
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int modify(TrialSceneReq sceneReq) {
        TrialSceneData sceneData = new TrialSceneData();
        sceneData.setId(sceneReq.getId());
        sceneData.setSceneDesc(sceneReq.getSceneDesc());
        sceneData.setModifyDate(LocalDateTime.now());
        return this.trialSceneMapper.updateById((Object)sceneData);
    }

    @Override
    public List<TrialSceneResp> list(TrialSceneReq sceneReq) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)sceneReq.getSceneKey())) {
            wrapper.likeRight((Object)"scene_key", (Object)sceneReq.getSceneKey());
        }
        List sceneDataList = this.trialSceneMapper.selectList((Wrapper)wrapper);
        return this.sceneDataToResp(sceneDataList);
    }

    @Override
    public TrialSceneResp listWithSteps(TrialSceneReq sceneReq) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isEmpty((CharSequence)sceneReq.getSceneKey())) {
            throw BusinessException.create((Integer)-1, (String)"Scene Key must exist");
        }
        wrapper.eq((Object)"scene_key", (Object)sceneReq.getSceneKey());
        TrialSceneData sceneData = (TrialSceneData)this.trialSceneMapper.selectOne((Wrapper)wrapper);
        TrialSceneResp resp = new TrialSceneResp();
        BeanUtils.copyProperties((Object)sceneData, (Object)resp);
        String sceneKey = resp.getSceneKey();
        QueryWrapper sceneStepWrapper = new QueryWrapper();
        sceneStepWrapper.eq((Object)"scene_key", (Object)sceneKey);
        List sceneStepList = this.trialSceneStepMapper.selectList((Wrapper)sceneStepWrapper);
        ArrayList<TrialStepResp> stepResps = new ArrayList<TrialStepResp>();
        for (TrialSceneStepData data : sceneStepList) {
            TrialStepResp stepResp = this.trialStepService.detail(data.getStepKey());
            stepResp.setRank(data.getRank());
            stepResps.add(stepResp);
        }
        resp.setSteps(stepResps);
        return resp;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int deleteById(Long id) {
        return this.trialSceneMapper.deleteById((Serializable)id);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public void bindSteps(TrialSceneStepBindReq req) {
        long sceneId = req.getSceneId();
        String sceneKey = req.getSceneKey();
        List<Map<String, Object>> steps = req.getSteps();
        UpdateWrapper delWrapper = new UpdateWrapper();
        delWrapper.eq((Object)"scene_id", (Object)sceneId);
        this.trialSceneStepMapper.delete((Wrapper)delWrapper);
        steps.forEach(x -> {
            TrialSceneStepData data = new TrialSceneStepData();
            data.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
            data.setSceneId(Long.valueOf(sceneId));
            data.setSceneKey(sceneKey);
            data.setStepId(Long.valueOf(MapUtils.getLongValue((Map)x, (Object)"stepId")));
            data.setStepKey(MapUtils.getString((Map)x, (Object)"stepKey"));
            data.setRank(MapUtils.getIntValue((Map)x, (Object)"rank"));
            data.setCreateDate(LocalDateTime.now());
            data.setModifyDate(LocalDateTime.now());
            this.trialSceneStepMapper.insert((Object)data);
        });
    }

    private List<TrialSceneResp> sceneDataToResp(List<TrialSceneData> dataList) {
        ArrayList<TrialSceneResp> respList = new ArrayList<TrialSceneResp>();
        dataList.forEach(x -> {
            TrialSceneResp resp = new TrialSceneResp();
            BeanUtils.copyProperties((Object)x, (Object)resp);
            respList.add(resp);
        });
        return respList;
    }

    @Override
    public boolean isSceneExist(String sceneKey) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"scene_key", (Object)sceneKey);
        Long result = this.trialSceneMapper.selectCount((Wrapper)query);
        return result > 0L;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int updateDetail(String sceneKey, String detail) {
        TrialSceneData data = new TrialSceneData();
        UpdateWrapper update = new UpdateWrapper();
        ((UpdateWrapper)update.set((Object)"detail", (Object)detail)).eq((Object)"scene_key", (Object)sceneKey);
        return this.trialSceneMapper.update((Object)data, (Wrapper)update);
    }

    @Override
    public TrialSceneData sceneDetail(String sceneKey) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"scene_key", (Object)sceneKey);
        return (TrialSceneData)this.trialSceneMapper.selectOne((Wrapper)query);
    }
}

