/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.trial;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.request.trial.step.TrialStepReq;
import com.digiwin.athena.base.application.meta.request.trial.step.TrialStepResp;
import com.digiwin.athena.base.application.service.trial.TrialStepService;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialStepMapper;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialStepData;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TrialStepServiceImpl
implements TrialStepService {
    private final TrialStepMapper trialStepMapper;

    @Autowired
    public TrialStepServiceImpl(TrialStepMapper trialStepMapper) {
        this.trialStepMapper = trialStepMapper;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public Long add(TrialStepReq stepReq) {
        TrialStepData stepData = new TrialStepData();
        BeanUtils.copyProperties((Object)stepReq, (Object)stepData);
        stepData.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        stepData.setCreateDate(LocalDateTime.now());
        stepData.setModifyDate(LocalDateTime.now());
        int result = this.trialStepMapper.insert((Object)stepData);
        return stepData.getId();
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int modify(TrialStepReq stepReq) {
        TrialStepData stepData = new TrialStepData();
        stepData.setModifyDate(LocalDateTime.now());
        stepData.setId(stepReq.getId());
        stepData.setStepDesc(stepReq.getStepDesc());
        stepData.setStepDetail(stepReq.getStepDetail());
        return this.trialStepMapper.updateById((Object)stepData);
    }

    @Override
    public List<TrialStepData> list(TrialStepReq stepReq) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)stepReq.getStepKey())) {
            wrapper.likeRight((Object)"step_key", (Object)stepReq.getStepKey());
        }
        return this.trialStepMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public TrialStepResp detail(String stepKey) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"step_key", (Object)stepKey);
        TrialStepData stepData = (TrialStepData)this.trialStepMapper.selectOne((Wrapper)wrapper);
        TrialStepResp resp = new TrialStepResp();
        BeanUtils.copyProperties((Object)stepData, (Object)resp);
        return resp;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int deleteById(Long id) {
        return this.trialStepMapper.deleteById((Serializable)id);
    }
}

