/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.userdefined;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.application.converter.DataConverter;
import com.digiwin.athena.base.application.meta.dto.userdefined.SearchConditionGroup;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserDefinedCenterDTO;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserDefinedCenterMetadataResult;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserGridDTO;
import com.digiwin.athena.base.application.service.userdefined.UserDefinedService;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.ThemeMapTag;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.ThemeMapTagResponse;
import com.digiwin.athena.base.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsResponse;
import com.digiwin.athena.base.infrastructure.mongo.UserDefinedMongoMapper;
import com.digiwin.athena.base.sdk.audc.application.service.userdefined.QueryUserDefinedService;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserGridPO;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserDefinedServiceImpl
implements UserDefinedService {
    private Logger logger = LoggerFactory.getLogger(UserDefinedServiceImpl.class);
    private String PURPOSE_FIELDSEQBYUSER = "FieldSeqByUser";
    private String PURPOSE_ORDERCONDITIONS = "OrderConditions";
    @Autowired
    private UserDefinedMongoMapper userDefinedMongoMapper;
    @Autowired
    private QueryUserDefinedService queryUserDefinedService;
    @Resource
    private MessageUtils messageUtils;

    @Override
    public void save(AuthoredUser user, JSONObject fieldJson) {
        this.logger.info("[UserDefinedServiceImpl.save],user is" + user + "fieldJson is" + fieldJson);
        try {
            if (fieldJson != null) {
                UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
                if (fieldJson.get("pageCode") != null) {
                    userDefined.setPageCode(fieldJson.getString("pageCode"));
                }
                if (fieldJson.get("tmDefinition") != null) {
                    JSONObject tmDefinition = fieldJson.getJSONObject("tmDefinition");
                    if (tmDefinition != null) {
                        if (tmDefinition.get("tmActivityId") != null) {
                            userDefined.setTmActivityId(tmDefinition.getString("tmActivityId"));
                        }
                        if (tmDefinition.get("tmProjectId") != null) {
                            userDefined.setTmProjectId(tmDefinition.getString("tmProjectId"));
                        } else {
                            userDefined.setTmProjectId("__uibot__");
                        }
                    }
                    if (fieldJson.get("fields") != null) {
                        JSONArray fieldsList = fieldJson.getJSONArray("fields");
                        int index = 1;
                        if ("project-detail".equals(userDefined.getPageCode())) {
                            index = 3;
                        }
                        ArrayList<UserDefinedCenterMetadataResult> metadataTags = new ArrayList<UserDefinedCenterMetadataResult>();
                        for (Map field : fieldsList) {
                            UserDefinedCenterMetadataResult metadataTagResult = new UserDefinedCenterMetadataResult();
                            if (field.get("name") == null) continue;
                            ThemeMapTag temp_tag = new ThemeMapTag();
                            if ("activity__performerName".equals(field.get("name").toString())) continue;
                            String orderCode = "ORDER_" + index;
                            temp_tag.setCode(orderCode);
                            temp_tag.setValue(String.valueOf(index));
                            temp_tag.setCategory("ORDER");
                            temp_tag.setName("xxxx");
                            temp_tag.setUiBotCode("ORDER");
                            ArrayList<ThemeMapTag> tags = new ArrayList<ThemeMapTag>();
                            tags.add(temp_tag);
                            metadataTagResult.setTags(tags);
                            ThemeMapTagResponse resourceContent = new ThemeMapTagResponse();
                            resourceContent.setResponse(field.get("name").toString());
                            metadataTagResult.setResourceContent(resourceContent);
                            String newField = field.get("name").toString();
                            if (field.get("name").toString().contains(".")) {
                                String[] fieldNames = field.get("name").toString().split("\\.");
                                newField = fieldNames[fieldNames.length - 1];
                                if (StringUtils.isEmpty((CharSequence)userDefined.getTableSchema())) {
                                    userDefined.setTableSchema(fieldNames[fieldNames.length - 2]);
                                }
                            }
                            index = field.get("name").toString().endsWith("_no") || field.get("name").toString().endsWith("_name") || field.get("name").toString().endsWith("_No") || field.get("name").toString().endsWith("_Name") || newField.startsWith("new_") || newField.startsWith("old_") ? (index += 4) : ++index;
                            HashMap<String, Object> extendedArr = new HashMap<String, Object>();
                            if (field.get("hide") != null) {
                                extendedArr.put("hide", Boolean.valueOf(field.get("hide").toString()));
                            }
                            if (field.get("pinned") != null) {
                                extendedArr.put("pinned", field.get("pinned").toString());
                            }
                            if (field.get("width") != null) {
                                extendedArr.put("width", field.get("width").toString());
                            }
                            if (MapUtils.isNotEmpty(extendedArr)) {
                                metadataTagResult.setExtendedAttributes(extendedArr);
                            }
                            metadataTags.add(metadataTagResult);
                        }
                        userDefined.setMetadataTags(metadataTags);
                    }
                }
                userDefined.setUserId(user.getUserId());
                userDefined.setTenantId(user.getTenantId());
                if (fieldJson.has("pageUniqueCode")) {
                    userDefined.setPageUniqueCode(fieldJson.getString("pageUniqueCode"));
                }
                this.userDefinedMongoMapper.save(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public UserDefinedCenterDTO getFieldSeqList(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        return this.getFieldSeqList(user, pageCode, tmProjectId, tmActivityId, tableSchema, null);
    }

    @Override
    public UserDefinedCenterDTO getFieldSeqList(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode) {
        UserDefinedPO userDefinedPO = this.queryUserDefinedService.getFieldSeqList(user, pageCode, tmProjectId, tmActivityId, tableSchema, pageUniqueCode);
        return DataConverter.INSTANCE.toUserDefinedCenterDTO(userDefinedPO);
    }

    @Override
    public List<UserDefinedFieldsResponse> getFieldSeqList(List<String> tmActivityIdList) {
        List fieldSeqList = this.queryUserDefinedService.getFieldSeqList(tmActivityIdList);
        if (CollectionUtils.isNotEmpty((Collection)fieldSeqList)) {
            return fieldSeqList.stream().map(DataConverter.INSTANCE::toUserDefinedFieldsResponse).collect(Collectors.toList());
        }
        return new ArrayList<UserDefinedFieldsResponse>();
    }

    @Override
    public void remove(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        if (StringUtils.isNotEmpty((CharSequence)tableSchema) && tableSchema.contains(".")) {
            tableSchema = tableSchema.split("\\.")[tableSchema.split("\\.").length - 1];
        }
        userDefined.setTableSchema(tableSchema);
        if ("undefined".equals(tmProjectId)) {
            tmProjectId = "__uibot__";
        }
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(this.PURPOSE_FIELDSEQBYUSER);
        this.userDefinedMongoMapper.remove(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
    }

    @Override
    public void saveOrderConditions(AuthoredUser user, JSONObject fieldJson) {
        try {
            if (fieldJson != null) {
                UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
                if (fieldJson.get("pageCode") != null) {
                    userDefined.setPageCode(fieldJson.getString("pageCode"));
                }
                if (fieldJson.get("tmDefinition") != null) {
                    JSONObject tmDefinition = fieldJson.getJSONObject("tmDefinition");
                    if (tmDefinition != null) {
                        if (tmDefinition.get("tmActivityId") != null) {
                            userDefined.setTmActivityId(tmDefinition.getString("tmActivityId"));
                        }
                        if (tmDefinition.get("tmProjectId") != null) {
                            userDefined.setTmProjectId(tmDefinition.getString("tmProjectId"));
                        } else {
                            userDefined.setTmProjectId("__uibot__");
                        }
                    }
                    if (fieldJson.get("fields") != null && !fieldJson.getJSONArray("fields").isEmpty()) {
                        JSONArray fieldList = fieldJson.getJSONArray("fields");
                        HashMap<String, JSONArray> options = new HashMap<String, JSONArray>();
                        options.put("options", fieldList);
                        HashMap<String, HashMap<String, JSONArray>> order = new HashMap<String, HashMap<String, JSONArray>>();
                        order.put("order", options);
                        JSONObject orderJson = JSONObject.fromObject(order);
                        userDefined.setSettings(orderJson);
                    }
                    if (fieldJson.containsKey((Object)"tableSchema") && fieldJson.get("tableSchema") != null) {
                        userDefined.setTableSchema(fieldJson.getString("tableSchema"));
                    }
                }
                userDefined.setUserId(user.getUserId());
                userDefined.setTenantId(user.getTenantId());
                if (fieldJson.has("pageUniqueCode")) {
                    userDefined.setPageUniqueCode(fieldJson.getString("pageUniqueCode"));
                }
                this.userDefinedMongoMapper.saveOrderConditions(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public UserDefinedCenterDTO getOrderConditionsByUser(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        return this.getOrderConditionsByUser(user, pageCode, tmProjectId, tmActivityId, tableSchema, null);
    }

    @Override
    public UserDefinedCenterDTO getOrderConditionsByUser(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode) {
        UserDefinedPO userDefinedPO = this.queryUserDefinedService.getOrderConditionsByUser(user, pageCode, tmProjectId, tmActivityId, tableSchema, pageUniqueCode);
        return DataConverter.INSTANCE.toUserDefinedCenterDTO(userDefinedPO);
    }

    @Override
    public List<UserDefinedCenterDTO> getOrderConditionsFields(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        List userDefinedPOS = this.queryUserDefinedService.getOrderConditionsFields(user, pageCode, tmProjectId, tmActivityId, tableSchema);
        if (CollectionUtils.isNotEmpty((Collection)userDefinedPOS)) {
            return userDefinedPOS.stream().map(DataConverter.INSTANCE::toUserDefinedCenterDTO).collect(Collectors.toList());
        }
        return new ArrayList<UserDefinedCenterDTO>();
    }

    @Override
    public void removeOrderConditions(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        userDefined.setTableSchema(tableSchema);
        if ("undefined".equals(tmProjectId)) {
            tmProjectId = "__uibot__";
        }
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(this.PURPOSE_ORDERCONDITIONS);
        this.userDefinedMongoMapper.remove(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
    }

    @Override
    public UserDefinedCenterDTO getUserShrink(AuthoredUser user, String tmActivityId) {
        UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setTmActivityId(tmActivityId);
        UserDefinedPO userShrink = this.userDefinedMongoMapper.getUserShrink(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
        return DataConverter.INSTANCE.toUserDefinedCenterDTO(userShrink);
    }

    @Override
    public void saveUserShrink(AuthoredUser user, JSONObject fieldJson) {
        try {
            if (fieldJson != null) {
                UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
                if (fieldJson.getString("tmActivityId") != null) {
                    userDefined.setTmActivityId(fieldJson.getString("tmActivityId"));
                }
                if (fieldJson.get("settings") != null) {
                    JSONArray settings = fieldJson.getJSONArray("settings");
                    HashMap<String, JSONArray> order = new HashMap<String, JSONArray>();
                    order.put("shrink", settings);
                    JSONObject orderJson = JSONObject.fromObject(order);
                    userDefined.setSettings(orderJson);
                }
                userDefined.setUserId(user.getUserId());
                userDefined.setTenantId(user.getTenantId());
                this.userDefinedMongoMapper.saveUserShrink(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object getFieldArrtList(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String table) {
        HashMap fieldArrMap = new HashMap();
        ArrayList columns = new ArrayList();
        HashMap columnAndSettingMap = new HashMap();
        columnAndSettingMap.put("columns", columns);
        UserDefinedCenterDTO userDefined = this.getFieldSeqList(user, pageCode, tmProjectId, tmActivityId, table);
        List<UserDefinedCenterMetadataResult> metadataMetadataTagResults = userDefined.getMetadataTags();
        if (CollectionUtils.isNotEmpty(metadataMetadataTagResults)) {
            this.sortTag(metadataMetadataTagResults);
            String userTable = "";
            for (UserDefinedCenterMetadataResult metadataTagResult : metadataMetadataTagResults) {
                HashMap<String, Object> oneMap = new HashMap<String, Object>();
                String schema = metadataTagResult.getResourceContent().getResponse();
                String path = metadataTagResult.getResourceContent().getResponse();
                if (metadataTagResult.getResourceContent().getResponse().contains(".")) {
                    String[] fieldNames = metadataTagResult.getResourceContent().getResponse().split("\\.");
                    schema = fieldNames[fieldNames.length - 1];
                    path = path.replaceFirst("." + schema, "");
                    if (StringUtils.isEmpty((CharSequence)userTable)) {
                        userTable = fieldNames[fieldNames.length - 2];
                    }
                }
                oneMap.put("schema", schema);
                oneMap.put("path", path);
                if (MapUtils.isNotEmpty(metadataTagResult.getExtendedAttributes())) {
                    Map<String, Object> extendedAttr = metadataTagResult.getExtendedAttributes();
                    if (extendedAttr.containsKey("hide")) {
                        oneMap.put("hide", Boolean.valueOf(extendedAttr.get("hide").toString()));
                    }
                    if (extendedAttr.containsKey("width")) {
                        oneMap.put("width", Double.valueOf(extendedAttr.get("width").toString()).intValue());
                    }
                    if (extendedAttr.containsKey("pinned")) {
                        oneMap.put("pinned", extendedAttr.get("pinned").toString());
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)metadataTagResult.getTags()) && !metadataTagResult.getTags().isEmpty()) {
                    int orderInt = Integer.parseInt(((ThemeMapTag)metadataTagResult.getTags().get(0)).getValue());
                    oneMap.put("order", orderInt);
                }
                columns.add(oneMap);
                if (StringUtils.isNotEmpty((CharSequence)table) && table.equals(userTable)) continue;
                table = userTable;
            }
        }
        fieldArrMap.put(table, columnAndSettingMap);
        JSONObject settings = new JSONObject();
        UserDefinedCenterDTO userDefinedSetting = this.getOrderConditionsByUser(user, pageCode, tmProjectId, tmActivityId, table);
        if (userDefinedSetting != null && userDefinedSetting.getSettings() != null) {
            settings = StringUtils.isNotEmpty((CharSequence)table) ? userDefinedSetting.getSettings().getJSONObject(table) : userDefinedSetting.getSettings();
        }
        columnAndSettingMap.put("settings", settings);
        return fieldArrMap;
    }

    private void sortTag(List<UserDefinedCenterMetadataResult> fields) {
        fields.sort((t0, t1) -> {
            List tag0 = t0.getTags();
            Integer a = 10000;
            if (!CollectionUtils.isEmpty((Collection)tag0)) {
                for (ThemeMapTag tag : tag0) {
                    if (!"ORDER".equals(tag.getCode())) continue;
                    try {
                        a = Integer.parseInt(tag.getValue());
                    }
                    catch (Exception e) {
                        a = 0;
                    }
                }
            }
            List tag1 = t1.getTags();
            Integer b = 10000;
            if (!CollectionUtils.isEmpty((Collection)tag1)) {
                for (ThemeMapTag tag : tag1) {
                    if (!"ORDER".equals(tag.getCode())) continue;
                    try {
                        b = Integer.parseInt(tag.getValue());
                    }
                    catch (Exception e) {
                        b = 0;
                    }
                }
            }
            return a - b;
        });
    }

    private void setUserInfo(AuthoredUser user, UserDefinedCenterDTO userDefined) {
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
    }

    @Override
    public Map<String, Object> saveSearchConditions(AuthoredUser user, UserDefinedCenterDTO userDefined) {
        String tmActivityId = userDefined.getTmActivityId();
        if (StringUtils.isBlank((CharSequence)tmActivityId)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(this.messageUtils.getMessage("exception.param.tmActivityId.null"));
        }
        String pageCode = userDefined.getPageCode();
        if (StringUtils.isBlank((CharSequence)pageCode)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(this.messageUtils.getMessage("exception.param.pageCode.null"));
        }
        String tableSchema = userDefined.getTableSchema();
        if (StringUtils.isBlank((CharSequence)tableSchema)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(this.messageUtils.getMessage("exception.param.tableSchema.null"));
        }
        String name = userDefined.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(this.messageUtils.getMessage("exception.param.name.null"));
        }
        List<SearchConditionGroup> paramConditions = userDefined.getSearchConditions();
        if (CollectionUtils.isEmpty(paramConditions)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_PARAM_ERROR.getBusinessException(this.messageUtils.getMessage("exception.param.searchCondition.null"));
        }
        this.setUserInfo(user, userDefined);
        List searchConditions = this.userDefinedMongoMapper.getSearchConditions(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
        if (CollectionUtils.isNotEmpty((Collection)searchConditions)) {
            throw AudcErrorCodeEnum.COMMON_REQUEST_DATA_REPEAT_ERROR.getBusinessException(this.messageUtils.getMessage("exception.param.name.repeat"));
        }
        Long id = this.userDefinedMongoMapper.saveSearchConditions(DataConverter.INSTANCE.toUserDefinedPO(userDefined));
        HashMap result = Maps.newHashMap();
        result.put("uniqueId", id);
        return result;
    }

    @Override
    public void delSearchConditions(AuthoredUser user, Long uniqueId) {
        this.userDefinedMongoMapper.delSearchConditions(user, uniqueId);
    }

    @Override
    public List<UserDefinedCenterDTO> getSearchConditions(AuthoredUser user, UserDefinedCenterDTO userDefined) {
        List searchConditions = this.queryUserDefinedService.getSearchConditions(user, DataConverter.INSTANCE.toUserDefinedPO(userDefined));
        if (CollectionUtils.isNotEmpty((Collection)searchConditions)) {
            return searchConditions.stream().map(DataConverter.INSTANCE::toUserDefinedCenterDTO).collect(Collectors.toList());
        }
        return new ArrayList<UserDefinedCenterDTO>();
    }

    @Override
    public void saveGridItems(UserGridDTO userGridDTO, AuthoredUser user) {
        userGridDTO.setUserId(user.getUserId());
        userGridDTO.setTenantId(user.getTenantId());
        try {
            this.userDefinedMongoMapper.saveGridItems(DataConverter.INSTANCE.toUserGridPO(userGridDTO));
        }
        catch (Exception e) {
            this.logger.error(" save grid items error: {}", (Object)e.getMessage());
        }
    }

    @Override
    public UserGridDTO getGridItems(UserGridDTO userGridDTO) {
        UserGridPO gridItems = this.queryUserDefinedService.getGridItems(DataConverter.INSTANCE.toUserGridPO(userGridDTO));
        return DataConverter.INSTANCE.toUserGridDTO(gridItems);
    }

    @Override
    public void delGridItems(Long uniqueId, AuthoredUser user) {
        this.userDefinedMongoMapper.delGridByUniqueId(uniqueId, user);
    }
}

