/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static String StreamToString(InputStream is) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, length);
            }
            outStream.close();
            is.close();
            return outStream.toString();
        }
        catch (IOException e) {
            logger.error("parse Stream error", (Throwable)e);
            return "";
        }
    }

    public static ProcessingReport validate(String dataString, String schemaString) {
        ProcessingReport processingReport = null;
        try {
            JsonNode dataNode = JsonLoader.fromString((String)dataString);
            JsonNode schemaNode = JsonLoader.fromString((String)schemaString);
            JsonSchema schema = JsonSchemaFactory.byDefault().getJsonSchema(schemaNode);
            processingReport = schema.validate(dataNode);
            return processingReport;
        }
        catch (ProcessingException | IOException ex) {
            logger.error("check json file error", ex);
            return processingReport;
        }
    }
}

