package com.digiwin.athena.base.application.service.commonused;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.dto.commonused.ItemsDto;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.ItemData;

import java.util.List;

public interface ItemService {
    /**
     * 查询对应的模块常用下子项信息
     *
     * @param user   用户信息
     * @param plat   所属模块0:基础资料录入 1：报表，后续有新增则依次递增
     * @param cateId 分类ID -1：根节点
     */
    List<ItemData> queryItemList(AuthoredUser user, Integer plat, Long cateId);

    /**
     * 新增子项
     *
     * @param user     用户信息
     * @param itemsDto 新增的子项信息
     * @return int
     */
    ItemData addItem(AuthoredUser user, ItemsDto itemsDto);

    /**
     * 移动单个子项
     *
     * @param id         需要移动的子项id
     * @param descCateId 移动后的子项分类 -1：根节点
     * @return int 结果
     */
    int moveSingleItem(Long id, Long descCateId);

    /**
     * 将某个分类下的子项全部移动到指定分类
     *
     * @param srcCateId  源分类ID -1：根节点
     * @param descCateId 目标分类ID -1：根节点
     * @return int 结果
     */
    int moveItemsByCate(Long srcCateId, Long descCateId, AuthoredUser user, int plat);


    /**
     * 根据id删除某个子项
     *
     * @param id 子项id
     * @return int 结果
     */
    int delete(AuthoredUser user, Long id);

    /**
     * 根据id删除某个子项
     *
     * @return int 结果
     */
    int delete(AuthoredUser user, Integer plat, String itemCode);

    /**
     * 判断是否已经设置为常用
     *
     * @param user     用户信息
     * @param plat     所属模块0:基础资料录入 1：报表，后续有新增则依次递增
     * @param itemCode 子项编码
     * @return
     */
    boolean checkUsed(AuthoredUser user, Integer plat, String itemCode);

    /**
     * 打开子项记录打开日志
     *
     * @param user    用户信息
     * @param itemDto 打开的子项洗洗
     * @param type    0：打开 1：取消常用 2：设置常用
     * @return int
     */
    int itemRecord(AuthoredUser user, ItemsDto itemDto, int type);


    /**
     * 自动添加到常用
     *
     * @param user    用户信息
     * @param itemDto 打开的子项洗洗
     * @return int
     */
    int autoInUsed(AuthoredUser user, ItemsDto itemDto);

    /**
     * 子项详情查询
     *
     * @param user 用户信息
     * @return int 结果
     */
    ItemData detail(AuthoredUser user, String itemCode, Integer plat);

    /**
     * 校验子项是否存在
     *
     * @param user     用户信息
     * @param itemsDto 子项信息
     */


    /**
     * 将某个分类下的子项全部删除
     *
     * @param srcCateId 源分类ID -1：根节点
     * @return int 结果
     */
    int deleteItemsByCate(Long srcCateId, AuthoredUser user, int plat);

    /**
     * 按照创建时间删除数据：删除一周前的数据，不包含当天
     *
     * @return
     */
    boolean deleteItemLogByCreateTime(long weeks);
}
