package com.digiwin.athena.base.application.service.usertrack.analyzer;


import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;

import java.util.List;

/**
 * 上报数据分析
 *
 * @author majianfu
 * @date 2022/6/8
 * @since
 */
public interface ReportDataAnalyzer {
    /**
     * 支持的上报类型
     *
     * @return
     */
    String getSourceType();

    /**
     * 分析上报数据
     *
     * @param reportDataList
     */
    void analysis(List<UserTrackExtendDTO> reportDataList);

    /**
     * 清除上报数据
     */
    void clear();
}
