package com.digiwin.athena.base.application.service.tenantconfig;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.infrastructure.mapper.audc.tenantconfig.TenantConfigMapper;
import com.digiwin.athena.base.infrastructure.meta.po.tenantconfig.TenantConfigPO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * TenantConfigServiceImpl Description
 *
 * @author majianfu
 * @date 2021/7/13
 * @since
 */
@Service
public class TenantConfigServiceImpl implements TenantConfigService {
    @Resource
    private TenantConfigMapper tenantConfigMapper;

    /**
     * {@inheritDoc}
     */
    @Override
    public TenantConfigPO getTenantConfig(AuthoredUser authoredUser, String tenantId, String category) {
        String targetTenantId = StringUtils.isBlank(tenantId) ? authoredUser.getTenantId() : tenantId;

        QueryWrapper<TenantConfigPO> condition = new QueryWrapper<>();
        condition.eq("tenant_id", targetTenantId).eq("config_name", category);
        return tenantConfigMapper.selectOne(condition);
    }
}
