package com.digiwin.athena.base.application.service.usertrack.analyzer;

import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 用户轨迹分析器
 *
 * @author majianfu
 * @date 2022/6/8
 * @since
 */
@Service
public class UserTrackAnalyzer extends AbstractReportDataAnalyzer {
    public static final String USER_TRACK_ANALYSIS = "userTrack_analyzer";

    /**
     * {@inheritDoc}
     */
    @Override
    public String getSourceType() {
        return USER_TRACK_ANALYSIS;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void analysis(List<UserTrackExtendDTO> userTrackDataList) {
        // 按租户分类上报的行为轨迹数据
        Map<String, List<UserTrackExtendDTO>> tenantTrackMap = new HashMap<>();
        userTrackDataList.stream().filter(userTrack -> StringUtils.isNotBlank(userTrack.getTenantId())).forEach(userTrack -> {
            List<UserTrackExtendDTO> tenantTrackList = tenantTrackMap.computeIfAbsent(userTrack.getTenantId(), tenantId -> new ArrayList<>());
            tenantTrackList.add(userTrack);
        });
        if (MapUtils.isEmpty(tenantTrackMap)) {
            return;
        }

        tenantTrackMap.forEach((tenantId, tenantTrackList) -> userTrackMapper.safeSaveTrackData(tenantId, tenantTrackList));
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void clear() {
        // do nothing
    }
}
