/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.calendar;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.application.service.calendar.CalendarService;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseActivityDefineDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CalendarServiceImpl
implements CalendarService {
    private static final String PATTERN = "CALENDAR";
    @Autowired
    private BaseThemeMapService baseThemeMapService;
    @Resource
    private MessageUtils messageUtils;

    @Override
    public List<BaseActivityDefineDTO> queryCalendarTaskList(AuthoredUser authoredUser, List<String> excludeCategories) {
        List taskList = this.baseThemeMapService.getTenantActivitiesByPattern(PATTERN);
        if (CollectionUtils.isNotEmpty((Collection)taskList) && CollectionUtils.isNotEmpty(excludeCategories)) {
            return taskList.stream().filter(task -> !excludeCategories.contains(task.getCategory())).collect(Collectors.toList());
        }
        return taskList;
    }

    @Override
    public List<BaseActivityDefineDTO> queryCalendarTaskList() {
        ArrayList<BaseActivityDefineDTO> taskList = this.baseThemeMapService.getTenantActivitiesByPattern(PATTERN);
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            taskList = new ArrayList<BaseActivityDefineDTO>(1);
        }
        BaseActivityDefineDTO baseActivityDefineDTO = new BaseActivityDefineDTO();
        baseActivityDefineDTO.setAppCode("athena");
        baseActivityDefineDTO.setAppName(this.messageUtils.getMessage("calendar.app.name"));
        baseActivityDefineDTO.setPattern(PATTERN);
        baseActivityDefineDTO.setCategory("PROCESS");
        baseActivityDefineDTO.setCode("platformManualTask");
        baseActivityDefineDTO.setName(this.messageUtils.getMessage("calendar.name"));
        taskList.add(baseActivityDefineDTO);
        return taskList;
    }
}

