/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.importstatistics;

import com.digiwin.athena.aim.sdk.meta.dto.response.ActivityAccessible;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.audc.CommonAudcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.iam.CommonUserService;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.dto.ActivityStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.BatchImportListRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadBaseDataDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadBaseDataParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadExportFileParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadTemplateDTO;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadTemplateReqDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ErrorTableDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportBasicDataRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportBatchRecord;
import com.digiwin.athena.atdm.importstatistics.dto.ExportHeaderRespDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ExportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.GetRecordsParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.ImportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UploadParamDTO;
import com.digiwin.athena.atdm.importstatistics.dto.UserStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.entity.CellTypeContainer;
import com.digiwin.athena.atdm.importstatistics.entity.ImportStatistics;
import com.digiwin.athena.atdm.importstatistics.entity.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.atdm.importstatistics.esp.api.EspBody;
import com.digiwin.athena.atdm.importstatistics.esp.api.EspResponse;
import com.digiwin.athena.atdm.importstatistics.kg.DataEntryKgService;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationRespDTO;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelTypeEnum;
import com.digiwin.athena.atdm.semc.CommonTddService;
import com.digiwin.athena.atdm.semc.dto.EncryptedConfigDTO;
import com.digiwin.athena.atdm.semc.dto.EncryptedConfigVO;
import com.digiwin.athena.base.application.service.importstatistics.HistoryProjectTaskServiceImpl;
import com.digiwin.athena.base.application.service.importstatistics.application.ApplicationService;
import com.digiwin.athena.base.application.service.importstatistics.service.DataEntryErrorHandlerService;
import com.digiwin.athena.base.application.service.importstatistics.service.DataEntryEspService;
import com.digiwin.athena.base.application.service.importstatistics.service.helpler.ExcelHelper;
import com.digiwin.athena.base.application.service.importstatistics.service.impl.DataEntryExportStatisticsDomainService;
import com.digiwin.athena.base.application.service.importstatistics.service.impl.DataEntryImportStatisticsDomainService;
import com.digiwin.athena.base.application.service.importstatistics.service.impl.DataEntryMetaDataService;
import com.digiwin.athena.base.application.service.importstatistics.worker.ExportFileMsg;
import com.digiwin.athena.base.infrastructure.manager.abt.AbtService;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BaseDataEntryApplicationServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDataEntryApplicationServiceImpl.class);
    @Autowired
    DataEntryImportStatisticsDomainService importStatisticsDomainService;
    @Autowired
    DataEntryExportStatisticsDomainService exportStatisticsDomainService;
    @Autowired
    DataEntryMetaDataService metaDataService;
    @Autowired
    DataEntryEspService espService;
    @Autowired
    ApplicationService applicationService;
    @Autowired
    @Qualifier(value="rabbitDataEntryErrorHandlerServiceImpl")
    DataEntryErrorHandlerService errorHandlerService;
    @Autowired
    ExcelHelper excelHelper;
    @Autowired
    AbtService abtService;
    @Autowired
    CommonTddService tddService;
    @Autowired
    private CommonUserService userService;
    @Autowired
    private DataEntryKgService kgService;
    @Autowired
    private HistoryProjectTaskServiceImpl historyProjectTaskService;
    @Autowired
    private CommonAudcService commonAudcService;

    public DapResponse dealUpload(UploadParamDTO uploadParam, MultipartFile file) {
        String appCode = this.getAppCode("activity", uploadParam.getActivityId());
        uploadParam.setApplication(appCode);
        this.abtService.handleUpload(uploadParam, file);
        return DapResponse.ok((Object)MessageUtil.getMessage((String)"delivery.success", (Object[])new Object[0]));
    }

    public void republish(UploadParamDTO uploadParamDTO) {
        String appCode = this.getAppCode("activity", uploadParamDTO.getActivityId());
        uploadParamDTO.setApplication(appCode);
        this.abtService.republish(uploadParamDTO);
    }

    public void uploadAsync(List<UploadParamDTO> uploadParamDTO) {
        this.abtService.uploadAsync(uploadParamDTO);
    }

    public List<ImportStatisticsDTO> getRecordsByUserId(AuthoredUser user, String locale, GetRecordsParamDTO getRecordsParam) {
        List records = this.abtService.getRecords(user, locale, getRecordsParam.getGetRecordsNum(), getRecordsParam.getActivityName(), getRecordsParam.getStartTime(), getRecordsParam.getEndTime(), getRecordsParam.getType(), getRecordsParam.getState(), getRecordsParam.getOffset());
        List activityIds = records.stream().map(ImportStatisticsDTO::getActivityId).collect(Collectors.toList());
        List accessibleList = this.commonAudcService.checkTypeActivitiesAccessible(activityIds);
        Map<Object, Object> map = new HashMap();
        if (accessibleList != null) {
            map = accessibleList.stream().flatMap(entry -> entry.getActivityAccessibleList().stream()).collect(Collectors.toMap(ActivityAccessible::getTmActivityId, ActivityAccessible::getAccess, (existing, replacement) -> replacement));
        }
        HashMap finalMap = map;
        records.forEach(e -> e.setAccess((String)finalMap.get(e.getActivityId())));
        return records;
    }

    public List<ExportStatisticsDTO> getExportRecordsByUserId(AuthoredUser user, String locale, GetRecordsParamDTO getRecordsParamDTO) {
        List exportRecords = this.abtService.getExportRecords(user, locale, getRecordsParamDTO);
        List activityIds = exportRecords.stream().flatMap(record -> {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(record.getActivityId());
            if (record.getExportBatchRecords() != null) {
                ids.addAll(record.getExportBatchRecords().stream().map(ExportBatchRecord::getCode).collect(Collectors.toList()));
            }
            return ids.stream();
        }).collect(Collectors.toList());
        List accessibleList = this.commonAudcService.checkTypeActivitiesAccessible(activityIds);
        Map<Object, Object> map = new HashMap();
        if (accessibleList != null) {
            map = accessibleList.stream().flatMap(entry -> entry.getActivityAccessibleList().stream()).collect(Collectors.toMap(ActivityAccessible::getTmActivityId, ActivityAccessible::getAccess, (existing, replacement) -> replacement));
        }
        HashMap finalMap = map;
        for (ExportStatisticsDTO exportStatisticsDTO : exportRecords) {
            exportStatisticsDTO.setAccess((String)finalMap.get(exportStatisticsDTO.getActivityId()));
            List exportBatchRecords = exportStatisticsDTO.getExportBatchRecords();
            if (exportBatchRecords == null) continue;
            for (ExportBatchRecord exportBatchRecord : exportBatchRecords) {
                exportBatchRecord.setAccess((String)finalMap.get(exportBatchRecord.getCode()));
            }
        }
        return exportRecords;
    }

    public ErrorTableDTO getErrorTableByMasterId(String masterId, String locale) {
        return this.abtService.getErrorTable(masterId, locale);
    }

    public void downloadErrorTable(String masterId, String locale, Set<String> requiredFields, HttpServletResponse response) {
        ImportStatistics importStatistics = new ImportStatistics();
        ImportStatisticsDTO importStatisticsDTO = this.abtService.queryImportStatistics(masterId);
        if (null == importStatisticsDTO) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0063.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.dataNotFound", (Object[])new Object[0]));
        }
        BeanUtils.copyProperties((Object)importStatisticsDTO, (Object)importStatistics);
        if (0 != importStatistics.getProcessingNum()) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0064.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.existRunningData", (Object[])new Object[0]));
        }
        if (0 == importStatistics.getFailedNum()) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0065.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.notFoundErrorData", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)importStatistics.getFailedUrl())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0066.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.notFoundErrorExcel", (Object[])new Object[0]));
        }
        List<Map> headers = this.metaDataService.getHeaders(importStatistics.getActionId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken(), locale);
        this.errorHandlerService.downloadErrorTable(importStatistics, headers, requiredFields, response);
    }

    public void downloadErrorTable(String masterId, String locale, HttpServletResponse response) {
        this.downloadErrorTable(masterId, locale, null, response);
    }

    public void downloadTemplateBatch(List<DownloadTemplateReqDTO> params, HttpServletResponse response, String locale) {
        this.metaDataService.downloadTemplateBatch(params, response, AppAuthContextHolder.getContext().getAuthoredUser().getToken(), locale);
    }

    public void downloadTemplate(String actionId, String locale, String fileName, DownloadTemplateDTO downloadTemplateDTO, HttpServletResponse response) {
        this.metaDataService.downloadTemplate(actionId, AppAuthContextHolder.getContext().getAuthoredUser().getToken(), locale, fileName, downloadTemplateDTO, response);
    }

    public void downloadTemplate(String actionId, String locale, String fileName, HttpServletResponse response) {
        this.metaDataService.downloadTemplate(actionId, AppAuthContextHolder.getContext().getAuthoredUser().getToken(), locale, fileName, response);
    }

    public UserStatisticsDTO getProcessingNum(String userId, String tenantId) {
        return this.abtService.getProcessingNum(userId, tenantId);
    }

    public UserStatisticsDTO getExportingNum(String userId, String tenantId, String type, List<String> types) {
        return this.abtService.getExportingNum(userId, tenantId, type, types);
    }

    public ImportStatisticsDTO getImportStatistics(String masterId) {
        return this.abtService.queryImportStatistics(masterId);
    }

    public ActivityStatisticsDTO getActivityStatistics(String activityCode, String userId) {
        return this.abtService.getActivityStatistics(activityCode, userId);
    }

    public void downloadBaseData(String actionId, DownloadBaseDataDTO downloadBaseDataDTO, String locale, HttpServletResponse response) {
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String productName = this.metaDataService.getProductName(athenaUser.getToken(), actionId.substring(actionId.contains("esp_") ? 4 : 0));
        GetActionLocaleResponseDTO metadataDTO = this.metaDataService.getActionMetaData(actionId, athenaUser.getToken(), locale);
        String mainKey = metadataDTO.getResponse().getData().getData_name();
        String mainKeyDescription = metadataDTO.getResponse().getData().getDescription();
        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setLocale(locale);
        exportFileMsg.setTenantId(athenaUser.getTenantId());
        exportFileMsg.setUserToken(athenaUser.getToken());
        exportFileMsg.setActionId(actionId);
        EspResponse espResponse = this.espService.getBaseData(downloadBaseDataDTO.getActionParas(), exportFileMsg, productName, null);
        if (!espResponse.isOK()) {
            log.error("downloadBaseData actionId:{},name:{},locale:{},userToken:{}", new Object[]{actionId, downloadBaseDataDTO, locale, athenaUser.getToken()});
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0067.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.exportDataError", (Object[])new Object[0]));
        }
        EspBody espBody = (EspBody)espResponse.getData();
        List tableList = (List)espBody.getStd_data().getParameter().get(mainKey);
        Map<String, CellTypeContainer> cellTypeContainerMap = this.metaDataService.getResponseCellTypeContainers(metadataDTO, athenaUser.getToken(), locale);
        ArrayList<String> keyList = new ArrayList<String>();
        Map<String, String> headers = this.metaDataService.getResponseHeaders(metadataDTO, keyList);
        try {
            this.importStatisticsDomainService.handleDownloadBaseData(locale, downloadBaseDataDTO.getName(), keyList, headers, cellTypeContainerMap, tableList, response, ExcelHelper.getSheetName(mainKey, mainKeyDescription, true));
        }
        catch (UnsupportedEncodingException e) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0068.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.downloadError", (Object[])new Object[0]));
        }
    }

    public void downloadBaseData(DownloadBaseDataParamDTO downloadBaseDataParamDTO, HttpServletResponse response) {
        response.setContentType(ExcelTypeEnum.XLSX.value());
        String encoding = "UTF-8";
        String formFileName = downloadBaseDataParamDTO.getActionInfo().getFileName() + ".xlsx";
        try (ServletOutputStream out = response.getOutputStream();){
            String appCode = this.getAppCode("activity", downloadBaseDataParamDTO.getActionInfo().getCode());
            downloadBaseDataParamDTO.setApplication(appCode);
            formFileName = URLEncoder.encode(formFileName, "UTF-8");
            response.setCharacterEncoding(encoding);
            formFileName = formFileName.replaceAll("\\+", "%20");
            response.addHeader("Content-Disposition", "attachment;filename=" + formFileName);
            response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
            byte[] fileBytes = this.abtService.downloadBaseData(downloadBaseDataParamDTO);
            out.write(fileBytes, 0, fileBytes.length);
            out.flush();
        }
        catch (IOException e) {
            log.error("downloadBaseData downloadBaseDataParamDTO:{},e:{}", (Object)downloadBaseDataParamDTO, (Object)e);
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0067.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.exportDataError", (Object[])new Object[0]));
        }
    }

    public void downloadExportFile(DownloadExportFileParamDTO downloadExportFileParamDTO, HttpServletResponse response) {
        ExportStatisticsDTO exportStatisticsDTO = this.abtService.queryExportStatistics(downloadExportFileParamDTO);
        if (null == exportStatisticsDTO) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0063.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.dataNotFound", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)exportStatisticsDTO.getFileUrl())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0066.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.notFoundExportExcel", (Object[])new Object[0]));
        }
        Date now = new Date();
        if (Objects.nonNull(exportStatisticsDTO.getExpireTime()) && now.after(exportStatisticsDTO.getExpireTime())) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0117.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.exportExcelIsExpire", (Object[])new Object[0]));
        }
        this.exportStatisticsDomainService.downloadExportFile(exportStatisticsDTO, response);
    }

    public Boolean retryDownload(DownloadExportFileParamDTO downloadExportFileParamDTO) {
        ExportStatisticsDTO exportStatisticsDTO = this.abtService.queryExportStatistics(downloadExportFileParamDTO);
        if (exportStatisticsDTO.getExportParams() == null || "".equals(exportStatisticsDTO.getExportParams())) {
            return true;
        }
        if ("4".equals(exportStatisticsDTO.getType())) {
            DownloadHistoryProjectTaskParamDTO downloadHistoryProjectTaskParamDTO = (DownloadHistoryProjectTaskParamDTO)JsonUtils.jsonToObject((String)exportStatisticsDTO.getExportParams(), DownloadHistoryProjectTaskParamDTO.class);
            this.historyProjectTaskService.startDownloadHistoryData(downloadHistoryProjectTaskParamDTO);
        } else {
            DownloadBaseDataParamDTO downloadBaseDataParamDTO = (DownloadBaseDataParamDTO)JsonUtils.jsonToObject((String)exportStatisticsDTO.getExportParams(), DownloadBaseDataParamDTO.class);
            this.startDownload(downloadBaseDataParamDTO);
        }
        this.abtService.updateRetryDownloadState(downloadExportFileParamDTO.getMasterId());
        return true;
    }

    public ExportHeaderRespDTO getTableHeader(String actionId) {
        return this.abtService.getTableHeader(actionId);
    }

    public List<BatchImportListRespDTO> getImportAndExportConfig() {
        return this.abtService.getImportBasicDataList();
    }

    public List<ExportBasicDataRespDTO> getExportBasicDataList() {
        return this.abtService.getExportBasicDataList();
    }

    public void startDownloadBatch(List<DownloadBaseDataParamDTO> params) {
        params.forEach(this::startDownload);
    }

    public Boolean startDownload(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        String code = downloadBaseDataParamDTO.getActionInfo().getCode();
        if ("split".equals(downloadBaseDataParamDTO.getExportMode())) {
            EncryptedConfigDTO encryptedConfigDTO = new EncryptedConfigDTO();
            encryptedConfigDTO.setActivityCode(code);
            EncryptedConfigVO encryptedConfig = this.tddService.getEncryptedConfig(encryptedConfigDTO);
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            AuthoredUser proxyAuthoredUser = AppAuthContextHolder.getContext().getProxyAuthoredUser();
            String token = Objects.nonNull(proxyAuthoredUser) ? proxyAuthoredUser.getToken() : authoredUser.getToken();
            Integer type = this.userService.queryUserType(authoredUser.getUserId(), token);
            if (Objects.nonNull(encryptedConfig) && 1 == encryptedConfig.getStatus() && Objects.nonNull(encryptedConfig.getScene()) && Objects.nonNull(encryptedConfig.getScope())) {
                EncryptedConfigVO.Scope scope = encryptedConfig.getScope();
                Boolean externalEmployee = Objects.nonNull(scope.getExternalEmployee()) && scope.getExternalEmployee() != false;
                Boolean internalEmployee = Objects.nonNull(scope.getInternalEmployee()) && scope.getInternalEmployee() != false;
                EncryptedConfigVO.Scene scene = encryptedConfig.getScene();
                Boolean download = Objects.nonNull(scene.getDownload()) && scene.getDownload() != false;
                if (download.booleanValue() && (type == 0 && internalEmployee.booleanValue() || type == 1 && externalEmployee.booleanValue())) {
                    EncryptedConfigVO.Rule rule = encryptedConfig.getRule();
                    Integer passwordLength = rule.getDefenceLength();
                    Integer passwordComplexity = rule.getDefenceComplexity();
                    String password = this.tddService.makePassword(passwordComplexity, passwordLength);
                    downloadBaseDataParamDTO.getActionInfo().setDefence(password);
                }
            }
        }
        String appCode = this.getAppCode("activity", code);
        downloadBaseDataParamDTO.setApplication(appCode);
        return this.abtService.startDownload(downloadBaseDataParamDTO);
    }

    private String getAppCode(String type, String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        String appCode = null;
        try {
            DapResponse dapResponse = this.kgService.getApplicationByTypeAndCode(type, code);
            if (null != dapResponse.getResponse()) {
                appCode = ((ApplicationRelationRespDTO)dapResponse.getResponse()).getApplication();
            }
        }
        catch (Exception ex) {
            log.error("getAppCode error: {}", (Throwable)ex);
        }
        return appCode;
    }
}

