package com.digiwin.athena.base.application.meta.response.attachment;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 上传附件文档中心返回参数
 * {
 *     "code":200,
 *     "message":"success",
 *     "data":{
 *         "id":"be2261b3-2280-433f-ae7f-9bea7ad6c7ea",
 *         "createBy":0,
 *         "createById":"Athena",
 *         "createDate":"2023-03-01 14:19:55",
 *         "modifyBy":0,
 *         "modifyById":"Athena",
 *         "modifyDate":"2023-03-01 14:19:55",
 *         "bucket":"Athena",
 *         "lastModifiedUser":"Athena",
 *         "lastModified":1677651595367,
 *         "fileName":"下载",
 *         "displayName":"下载",
 *         "description":"下载",
 *         "size":38599,
 *         "contentType":"application/octet-stream",
 *         "completed":true,
 *         "metadata":{
 *
 *         },
 *         "directoryId":"00000000-0000-0000-0000-000000000000",
 *         "directoryName":"根目录",
 *         "fileId":"63feee8b3481800020c92dd9",
 *         "bucketName":"Athena",
 *         "totalSize":0,
 *         "uploadDate":1677651595365,
 *         "visits":0,
 *         "push":false,
 *         "coverDate":"2023-03-01 14:19:55"
 *     },
 *     "success":true
 * }
 */
@Data
@NoArgsConstructor
public class UploadAttachmentRespDTO {

    /**
     * 文档中心生成的附件id
     */
    private String id;

    /**
     * 文件存储路径
     */
    private String bucketName;

    /**
     * 文件id
     */
    private String fileId;

    /**
     * 文件名称
     */
    private String fileName;
}
