package com.digiwin.athena.base.application.service.cofw;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.infrastructure.meta.po.cofw.Cofw;
import net.sf.json.JSONObject;

import java.util.List;

/**
 * CofwService Description
 *
 * @author xuxx
 * @date 2021/8/28
 * @since
 */
public interface CofwService {
    /**
     * 快照保存
     *
     * @param user
     * @param cofwSaveBody
     */
    void save(AuthoredUser user, JSONObject cofwSaveBody);

    /**
     * 根据当前用户信息，获取快照列表
     *
     * @param user
     * @return
     */
    List<Cofw> getCofwList(AuthoredUser user);

    /**
     * 根据快照ID获取某一个快照信息
     */
    Cofw getOneCofwById(long id);

    /**
     * 根据快照ID更新快照信息
     *
     * @param cofw
     */
    void updateCofwById(Cofw cofw);

    /**
     * 根据租户id清理租户的快照数据
     *
     * @param tenantId 租户id
     * @return 操作结果
     */
    int deleteByTenant(String tenantId);
}
