package com.digiwin.athena.base.application.service.importstatistics.service.helpler;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.atdm.cac.dto.UserAppDTO;
import com.digiwin.athena.atdm.cac.CommonCacService;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.TmAppDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 *
 */
@Slf4j
@Service
public class AppPermissionUtil {

    @Autowired
    private BaseThemeMapService themeMapService;

    @Autowired
    private CommonCacService cacService;

    /**
     * 过滤已授权应用的作业
     *
     * @param activityCodeList
     * @return
     */
    public List<String> handleAppPermission(List<String> activityCodeList) {
        if (CollectionUtil.isEmpty(activityCodeList)) {
            return activityCodeList;
        }

        // 获取当前用户所有的应用权限
        List<UserAppDTO> userAppDTOS = cacService.qryUserApp();
        // 用户没有任何权限
        if (CollectionUtil.isEmpty(userAppDTOS)) {
            return new ArrayList<>();
        }
        List<String> userAppCodeList = userAppDTOS.stream().map(UserAppDTO::getId).distinct().collect(Collectors.toList());

        // 查询code对应的应用信息
        List<TmAppDTO> tmAppDTOS = themeMapService.getAppInfoByCodeAndType("task", activityCodeList);
        // Key是activityCode,value是list，因为一个活动会存在于多个应用
        Map<String, List<TmAppDTO>> codeAppRel = tmAppDTOS.stream().collect(Collectors.groupingBy(TmAppDTO::getCode));

        List<String> hasPermissionActivityCodeList = new ArrayList<>();
        activityCodeList.forEach(activityCode -> {
            if (hasAppPermission(codeAppRel.get(activityCode), userAppCodeList)) {
                hasPermissionActivityCodeList.add(activityCode);
            }
        });
        return hasPermissionActivityCodeList;
    }

    private boolean hasAppPermission(List<TmAppDTO> tmAppList, List<String> appCodeList) {
        if (CollectionUtils.isEmpty(tmAppList)) {
            return false;
        }
        List<String> appCodes = tmAppList.stream().map(TmAppDTO::getAppCode).distinct().collect(Collectors.toList());
        return CollectionUtil.containsAny(appCodeList, appCodes);
    }
}
