package com.digiwin.athena.base.application.service.trial;


import com.digiwin.athena.base.application.meta.request.trial.scene.TrialSceneReq;
import com.digiwin.athena.base.application.meta.request.trial.scene.TrialSceneResp;
import com.digiwin.athena.base.application.meta.request.trial.sceneStep.TrialSceneStepBindReq;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialSceneData;

import java.util.List;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/03 16:40:16
 */
public interface TrialSceneService {
    /**
     * 新增试用场景
     *
     * @param sceneReq sceneReq
     * @return int
     */
    Long add(TrialSceneReq sceneReq);

    /**
     * 修改试用场景
     *
     * @param sceneReq sceneReq
     * @return int
     */
    int modify(TrialSceneReq sceneReq);

    /**
     * 查询试用场景列表
     *
     * @return list
     */
    List<TrialSceneResp> list(TrialSceneReq sceneReq);

    /**
     * 根据id删除试用场景
     *
     * @param id id
     * @return int
     */
    int deleteById(Long id);

    /**
     * 场景绑定步骤
     *
     * @param req req
     */
    void bindSteps(TrialSceneStepBindReq req);

    /**
     * 查询试用场景列表
     *
     * @return list
     */
    TrialSceneResp listWithSteps(TrialSceneReq sceneReq);


    /**
     * 判断场景是否存在
     *
     * @param sceneKey sceneKey
     * @return true or false
     */
    boolean isSceneExist(String sceneKey);

    /**
     * 判断场景是否存在
     *
     * @param sceneKey sceneKey
     * @return true or false
     */
    int updateDetail(String sceneKey, String detail);

    /**
     * 根据scenekey查询场景详情
     *
     * @param sceneKey sceneKey
     * @return int
     */
    TrialSceneData sceneDetail(String sceneKey);
}